"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RaftAutopilot = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/raft_autopilot vault_raft_autopilot}
*/
class RaftAutopilot extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/raft_autopilot vault_raft_autopilot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RaftAutopilotConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'vault_raft_autopilot',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.7.0',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._cleanupDeadServers = config.cleanupDeadServers;
        this._deadServerLastContactThreshold = config.deadServerLastContactThreshold;
        this._id = config.id;
        this._lastContactThreshold = config.lastContactThreshold;
        this._maxTrailingLogs = config.maxTrailingLogs;
        this._minQuorum = config.minQuorum;
        this._namespace = config.namespace;
        this._serverStabilizationTime = config.serverStabilizationTime;
    }
    get cleanupDeadServers() {
        return this.getBooleanAttribute('cleanup_dead_servers');
    }
    set cleanupDeadServers(value) {
        this._cleanupDeadServers = value;
    }
    resetCleanupDeadServers() {
        this._cleanupDeadServers = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cleanupDeadServersInput() {
        return this._cleanupDeadServers;
    }
    get deadServerLastContactThreshold() {
        return this.getStringAttribute('dead_server_last_contact_threshold');
    }
    set deadServerLastContactThreshold(value) {
        this._deadServerLastContactThreshold = value;
    }
    resetDeadServerLastContactThreshold() {
        this._deadServerLastContactThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deadServerLastContactThresholdInput() {
        return this._deadServerLastContactThreshold;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get lastContactThreshold() {
        return this.getStringAttribute('last_contact_threshold');
    }
    set lastContactThreshold(value) {
        this._lastContactThreshold = value;
    }
    resetLastContactThreshold() {
        this._lastContactThreshold = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lastContactThresholdInput() {
        return this._lastContactThreshold;
    }
    get maxTrailingLogs() {
        return this.getNumberAttribute('max_trailing_logs');
    }
    set maxTrailingLogs(value) {
        this._maxTrailingLogs = value;
    }
    resetMaxTrailingLogs() {
        this._maxTrailingLogs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxTrailingLogsInput() {
        return this._maxTrailingLogs;
    }
    get minQuorum() {
        return this.getNumberAttribute('min_quorum');
    }
    set minQuorum(value) {
        this._minQuorum = value;
    }
    resetMinQuorum() {
        this._minQuorum = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minQuorumInput() {
        return this._minQuorum;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get serverStabilizationTime() {
        return this.getStringAttribute('server_stabilization_time');
    }
    set serverStabilizationTime(value) {
        this._serverStabilizationTime = value;
    }
    resetServerStabilizationTime() {
        this._serverStabilizationTime = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get serverStabilizationTimeInput() {
        return this._serverStabilizationTime;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            cleanup_dead_servers: cdktf.booleanToTerraform(this._cleanupDeadServers),
            dead_server_last_contact_threshold: cdktf.stringToTerraform(this._deadServerLastContactThreshold),
            id: cdktf.stringToTerraform(this._id),
            last_contact_threshold: cdktf.stringToTerraform(this._lastContactThreshold),
            max_trailing_logs: cdktf.numberToTerraform(this._maxTrailingLogs),
            min_quorum: cdktf.numberToTerraform(this._minQuorum),
            namespace: cdktf.stringToTerraform(this._namespace),
            server_stabilization_time: cdktf.stringToTerraform(this._serverStabilizationTime),
        };
    }
}
exports.RaftAutopilot = RaftAutopilot;
_a = JSII_RTTI_SYMBOL_1;
RaftAutopilot[_a] = { fqn: "@cdktf/provider-vault.RaftAutopilot", version: "0.0.15" };
// =================
// STATIC PROPERTIES
// =================
RaftAutopilot.tfResourceType = "vault_raft_autopilot";
//# sourceMappingURL=data:application/json;base64,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