import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TransformTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * The alphabet to use for this template. This is only used during FPE transformations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#alphabet TransformTemplate#alphabet}
    */
    readonly alphabet?: string;
    /**
    * The map of regular expression templates used to customize decoded outputs.
  Only applicable to FPE transformations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#decode_formats TransformTemplate#decode_formats}
    */
    readonly decodeFormats?: {
        [key: string]: string;
    };
    /**
    * The regular expression template used for encoding values.
  Only applicable to FPE transformations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#encode_format TransformTemplate#encode_format}
    */
    readonly encodeFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#id TransformTemplate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the template.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#name TransformTemplate#name}
    */
    readonly name: string;
    /**
    * The mount path for a back-end, for example, the path given in "$ vault auth enable -path=my-aws aws".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#path TransformTemplate#path}
    */
    readonly path: string;
    /**
    * The pattern used for matching. Currently, only regular expression pattern is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#pattern TransformTemplate#pattern}
    */
    readonly pattern?: string;
    /**
    * The pattern type to use for match detection. Currently, only regex is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transform_template#type TransformTemplate#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/transform_template vault_transform_template}
*/
export declare class TransformTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_transform_template";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/transform_template vault_transform_template} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TransformTemplateConfig
    */
    constructor(scope: Construct, id: string, config: TransformTemplateConfig);
    private _alphabet?;
    get alphabet(): string;
    set alphabet(value: string);
    resetAlphabet(): void;
    get alphabetInput(): string | undefined;
    private _decodeFormats?;
    get decodeFormats(): {
        [key: string]: string;
    };
    set decodeFormats(value: {
        [key: string]: string;
    });
    resetDecodeFormats(): void;
    get decodeFormatsInput(): {
        [key: string]: string;
    } | undefined;
    private _encodeFormat?;
    get encodeFormat(): string;
    set encodeFormat(value: string);
    resetEncodeFormat(): void;
    get encodeFormatInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    resetPattern(): void;
    get patternInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
