"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const aws_events_1 = require("@aws-cdk/aws-events");
const cdk = require("@aws-cdk/core");
const _1 = require("./");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const stack = new cdk.Stack(app, 'my-stack-dev');
        const kaniko = new _1.Kaniko(stack, 'KanikoDemo', {
            context: 'git://github.com/pahud/vscode.git',
            contextSubPath: './.devcontainer',
        });
        // build it once
        kaniko.buildImage();
        // schedule the build every day 0:00AM
        kaniko.buildImage(aws_events_1.Schedule.cron({
            minute: '0',
            hour: '0',
        }));
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLG9EQUErQztBQUMvQyxxQ0FBcUM7QUFDckMseUJBQTRCO0FBRTVCLE1BQWEsWUFBWTtJQUV2QjtRQUNFLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO1FBRTFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsY0FBYyxDQUFDLENBQUM7UUFFakQsTUFBTSxNQUFNLEdBQUcsSUFBSSxTQUFNLENBQUMsS0FBSyxFQUFFLFlBQVksRUFBRTtZQUM3QyxPQUFPLEVBQUUsbUNBQW1DO1lBQzVDLGNBQWMsRUFBRSxpQkFBaUI7U0FDbEMsQ0FBQyxDQUFDO1FBRUgsZ0JBQWdCO1FBQ2hCLE1BQU0sQ0FBQyxVQUFVLEVBQUUsQ0FBQztRQUVwQixzQ0FBc0M7UUFDdEMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxxQkFBUSxDQUFDLElBQUksQ0FBQztZQUM5QixNQUFNLEVBQUUsR0FBRztZQUNYLElBQUksRUFBRSxHQUFHO1NBQ1YsQ0FBQyxDQUFDLENBQUM7UUFFSixJQUFJLENBQUMsS0FBSyxHQUFHLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDdkIsQ0FBQztDQUNGO0FBdkJELG9DQXVCQztBQUVELElBQUksWUFBWSxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBTY2hlZHVsZSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1ldmVudHMnO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgS2FuaWtvIH0gZnJvbSAnLi8nO1xuXG5leHBvcnQgY2xhc3MgSW50ZWdUZXN0aW5nIHtcbiAgcmVhZG9ubHkgc3RhY2s6IGNkay5TdGFja1tdO1xuICBjb25zdHJ1Y3RvcigpIHtcbiAgICBjb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuXG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKGFwcCwgJ215LXN0YWNrLWRldicpO1xuXG4gICAgY29uc3Qga2FuaWtvID0gbmV3IEthbmlrbyhzdGFjaywgJ0thbmlrb0RlbW8nLCB7XG4gICAgICBjb250ZXh0OiAnZ2l0Oi8vZ2l0aHViLmNvbS9wYWh1ZC92c2NvZGUuZ2l0JyxcbiAgICAgIGNvbnRleHRTdWJQYXRoOiAnLi8uZGV2Y29udGFpbmVyJyxcbiAgICB9KTtcblxuICAgIC8vIGJ1aWxkIGl0IG9uY2VcbiAgICBrYW5pa28uYnVpbGRJbWFnZSgpO1xuXG4gICAgLy8gc2NoZWR1bGUgdGhlIGJ1aWxkIGV2ZXJ5IGRheSAwOjAwQU1cbiAgICBrYW5pa28uYnVpbGRJbWFnZShTY2hlZHVsZS5jcm9uKHtcbiAgICAgIG1pbnV0ZTogJzAnLFxuICAgICAgaG91cjogJzAnLFxuICAgIH0pKTtcblxuICAgIHRoaXMuc3RhY2sgPSBbc3RhY2tdO1xuICB9XG59XG5cbm5ldyBJbnRlZ1Rlc3RpbmcoKTtcbiJdfQ==