import * as ecr from '@aws-cdk/aws-ecr';
import * as ecs from '@aws-cdk/aws-ecs';
import { Schedule } from '@aws-cdk/aws-events';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface KanikoProps {
    /**
     * Kaniko build context.
     *
     * @see https://github.com/GoogleContainerTools/kaniko#kaniko-build-contexts
     * @stability stable
     */
    readonly context: string;
    /**
     * The target ECR repository.
     *
     * @default - create a new ECR private repository
     * @stability stable
     */
    readonly destinationRepository?: ecr.IRepository;
    /**
     * The context sub path.
     *
     * @stability stable
     * @defautl - current directory
     */
    readonly contextSubPath?: string;
    /**
     * The Dockerfile for the image building.
     *
     * @default Dockerfile
     * @stability stable
     */
    readonly dockerfile?: string;
}
/**
 * @stability stable
 */
export declare class Kaniko extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly destinationRepository: ecr.IRepository;
    /**
     * @stability stable
     */
    readonly cluster: ecs.ICluster;
    /**
     * @stability stable
     */
    readonly task: ecs.FargateTaskDefinition;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: KanikoProps);
    private _createDestinationRepository;
    /**
     * Build the image with kaniko.
     *
     * @param schedule The schedule to repeatedly build the image.
     * @stability stable
     */
    buildImage(schedule?: Schedule): void;
}
