from typing import Optional, Dict, List
from jsonalias import Json

class UiDataSliceConfig:
    def __init__(self, offset: int, length: int) -> None: ...
    @property
    def offset(self) -> int: ...
    @property
    def length(self) -> int: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self, other: "UiDataSliceConfig", op: int) -> bool: ...

class UiAccountEncoding:
    Binary: "UiAccountEncoding"
    Base58: "UiAccountEncoding"
    Base64: "UiAccountEncoding"
    JsonParsed: "UiAccountEncoding"
    Base64Zstd: "UiAccountEncoding"
    def __int__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...

class ParsedAccount:
    def __init__(self, program: str, parsed: Dict[str, Json], space: int) -> None: ...
    def __bytes__(self) -> bytes: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self, other: "ParsedAccount", op: int) -> bool: ...
    @staticmethod
    def from_bytes(raw_bytes: bytes) -> "ParsedAccount": ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "ParsedAccount": ...
    @property
    def program(self) -> str: ...
    @property
    def parsed(self) -> Dict[str, Json]: ...
    @property
    def space(self) -> int: ...

class UiTokenAmount:
    def __init__(
        self,
        ui_amount: Optional[float],
        decimals: int,
        amount: str,
        ui_amount_string: str,
    ) -> None: ...
    @property
    def ui_amount(self) -> Optional[float]: ...
    @property
    def decimals(self) -> int: ...
    @property
    def amount(self) -> str: ...
    @property
    def ui_amount_string(self) -> str: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "UiTokenAmount": ...
    @staticmethod
    def from_bytes(data: bytes) -> "UiTokenAmount": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...
