from typing import Optional, Sequence, List, Union
from solders.pubkey import Pubkey
from solders.rpc.config import (
    RpcAccountInfoConfig,
    RpcContextConfig,
    RpcBlockConfig,
    RpcEpochConfig,
    RpcBlockProductionConfig,
    RpcLargestAccountsFilter,
    RpcLeaderScheduleConfig,
    RpcProgramAccountsConfig,
    RpcSignaturesForAddressConfig,
    RpcSignatureStatusConfig,
    RpcSupplyConfig,
    RpcTokenAccountsFilterMint,
    RpcTokenAccountsFilterProgramId,
    RpcTransactionConfig,
    RpcGetVoteAccountsConfig,
    RpcRequestAirdropConfig,
    RpcSendTransactionConfig,
    RpcSimulateTransactionConfig,
    RpcBlockSubscribeConfig,
    RpcBlockSubscribeFilter,
    RpcBlockSubscribeFilterMentions,
    RpcSignatureSubscribeConfig,
    RpcTransactionLogsConfig,
    RpcTransactionLogsFilter,
    RpcTransactionLogsFilterMentions,
)
from solders.commitment_config import CommitmentLevel
from solders.signature import Signature
from solders.message import Message
from solders.hash import Hash
from solders.transaction import Transaction, VersionedTransaction

class GetAccountInfo:
    def __init__(
        self,
        pubkey: Pubkey,
        config: Optional[RpcAccountInfoConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def pubkey(self) -> Pubkey: ...
    @property
    def config(self) -> Optional[RpcAccountInfoConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetAccountInfo": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetAccountInfo": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetBalance:
    def __init__(
        self,
        pubkey: Pubkey,
        config: Optional[RpcContextConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def pubkey(self) -> Pubkey: ...
    @property
    def config(self) -> Optional[RpcContextConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetBalance": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetBalance": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetBlock:
    def __init__(
        self,
        slot: int,
        config: Optional[RpcBlockConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def slot(self) -> int: ...
    @property
    def config(self) -> Optional[RpcBlockConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetBlock": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetBlock": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetBlockHeight:
    def __init__(
        self, config: Optional[RpcContextConfig] = None, id: Optional[int] = None
    ): ...
    @property
    def config(self) -> Optional[RpcContextConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetBlockHeight": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetBlockHeight": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetBlockProduction:
    def __init__(
        self,
        config: Optional[RpcBlockProductionConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def config(self) -> Optional[RpcBlockProductionConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetBlockProduction": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetBlockProduction": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetBlockCommitment:
    def __init__(self, slot: int, id: Optional[int] = None): ...
    @property
    def slot(self) -> int: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetBlockCommitment": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetBlockCommitment": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetBlocks:
    def __init__(
        self,
        start: int,
        end: Optional[int] = None,
        commitment: Optional[CommitmentLevel] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def start(self) -> int: ...
    @property
    def end(self) -> Optional[int]: ...
    @property
    def commitment(self) -> Optional[CommitmentLevel]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetBlocks": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetBlocks": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetBlocksWithLimit:
    def __init__(
        self,
        start: int,
        limit: Optional[int] = None,
        commitment: Optional[CommitmentLevel] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def start(self) -> int: ...
    @property
    def limit(self) -> Optional[int]: ...
    @property
    def commitment(self) -> Optional[CommitmentLevel]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetBlocksWithLimit": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetBlocksWithLimit": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetBlockTime:
    def __init__(self, slot: int, id: Optional[int] = None): ...
    @property
    def slot(self) -> int: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetBlockTime": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetBlockTime": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetEpochInfo:
    def __init__(
        self, config: Optional[RpcContextConfig] = None, id: Optional[int] = None
    ): ...
    @property
    def config(self) -> Optional[RpcContextConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetEpochInfo": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetEpochInfo": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetFeeForMessage:
    def __init__(
        self,
        message: Message,
        commitment: Optional[CommitmentLevel] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def message(self) -> Message: ...
    @property
    def commitment(self) -> Optional[CommitmentLevel]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetFeeForMessage": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetFeeForMessage": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetIdentity:
    def __init__(self, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetIdentity": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetIdentity": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetInflationGovernor:
    def __init__(
        self, commitment: Optional[CommitmentLevel] = None, id: Optional[int] = None
    ): ...
    @property
    def commitment(self) -> Optional[CommitmentLevel]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetInflationGovernor": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetInflationGovernor": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetInflationReward:
    def __init__(
        self,
        addresses: Sequence[Pubkey],
        config: Optional[RpcEpochConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def addresses(self) -> List[Pubkey]: ...
    @property
    def config(self) -> Optional[RpcEpochConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetInflationReward": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetInflationReward": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetLargestAccounts:
    def __init__(
        self,
        commitment: Optional[CommitmentLevel] = None,
        filter_: Optional[RpcLargestAccountsFilter] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def commitment(self) -> Optional[CommitmentLevel]: ...
    @property
    def filter_(self) -> Optional[RpcLargestAccountsFilter]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetLargestAccounts": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetLargestAccounts": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetLatestBlockhash:
    def __init__(
        self, config: Optional[RpcContextConfig] = None, id: Optional[int] = None
    ): ...
    @property
    def config(self) -> Optional[RpcContextConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetLatestBlockhash": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetLatestBlockhash": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetLeaderSchedule:
    def __init__(
        self,
        slot: Optional[int] = None,
        config: Optional[RpcLeaderScheduleConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def slot(self) -> Optional[int]: ...
    @property
    def config(self) -> Optional[RpcLeaderScheduleConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetLeaderSchedule": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetLeaderSchedule": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetMinimumBalanceForRentExemption:
    def __init__(
        self,
        length: int,
        commitment: Optional[CommitmentLevel] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def length(self) -> int: ...
    @property
    def commitment(self) -> Optional[CommitmentLevel]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetMinimumBalanceForRentExemption": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetMinimumBalanceForRentExemption": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetMultipleAccounts:
    def __init__(
        self,
        accounts: Sequence[Pubkey],
        config: Optional[RpcAccountInfoConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def accounts(self) -> List[Pubkey]: ...
    @property
    def config(self) -> Optional[RpcAccountInfoConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetMultipleAccounts": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetMultipleAccounts": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetProgramAccounts:
    def __init__(
        self,
        program: Pubkey,
        config: Optional[RpcProgramAccountsConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def program(self) -> Pubkey: ...
    @property
    def config(self) -> Optional[RpcProgramAccountsConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetProgramAccounts": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetProgramAccounts": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetRecentPerformanceSamples:
    def __init__(self, limit: Optional[int] = None, id: Optional[int] = None): ...
    @property
    def limit(self) -> Optional[int]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetRecentPerformanceSamples": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetRecentPerformanceSamples": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetSignaturesForAddress:
    def __init__(
        self,
        address: Pubkey,
        config: Optional[RpcSignaturesForAddressConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def address(self) -> Pubkey: ...
    @property
    def config(self) -> Optional[RpcSignaturesForAddressConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetSignaturesForAddress": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetSignaturesForAddress": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetSignatureStatuses:
    def __init__(
        self,
        signatures: Sequence[Signature],
        config: Optional[RpcSignatureStatusConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def signatures(self) -> List[Signature]: ...
    @property
    def config(self) -> Optional[RpcSignatureStatusConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetSignatureStatuses": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetSignatureStatuses": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetSlot:
    def __init__(
        self, config: Optional[RpcContextConfig] = None, id: Optional[int] = None
    ): ...
    @property
    def config(self) -> Optional[RpcContextConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetSlot": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetSlot": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetSlotLeader:
    def __init__(
        self, config: Optional[RpcContextConfig] = None, id: Optional[int] = None
    ): ...
    @property
    def config(self) -> Optional[RpcContextConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetSlotLeader": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetSlotLeader": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetSlotLeaders:
    def __init__(self, start: int, limit: int, id: Optional[int] = None): ...
    @property
    def start(self) -> int: ...
    @property
    def limit(self) -> int: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetSlotLeaders": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetSlotLeaders": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetStakeActivation:
    def __init__(
        self,
        account: Pubkey,
        config: Optional[RpcEpochConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def account(self) -> Pubkey: ...
    @property
    def config(self) -> Optional[RpcEpochConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetStakeActivation": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetStakeActivation": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetSupply:
    def __init__(
        self, config: Optional[RpcSupplyConfig] = None, id: Optional[int] = None
    ): ...
    @property
    def config(self) -> Optional[RpcSupplyConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetSupply": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetSupply": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetTokenAccountBalance:
    def __init__(
        self,
        account: Pubkey,
        commitment: Optional[CommitmentLevel] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def account(self) -> Pubkey: ...
    @property
    def commitment(self) -> Optional[CommitmentLevel]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetTokenAccountBalance": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetTokenAccountBalance": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetTokenAccountsByDelegate:
    def __init__(
        self,
        account: Pubkey,
        filter_: Union[RpcTokenAccountsFilterMint, RpcTokenAccountsFilterProgramId],
        config: Optional[RpcAccountInfoConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def account(self) -> Pubkey: ...
    @property
    def filter_(
        self,
    ) -> Union[RpcTokenAccountsFilterMint, RpcTokenAccountsFilterProgramId]: ...
    @property
    def config(self) -> Optional[RpcAccountInfoConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetTokenAccountsByDelegate": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetTokenAccountsByDelegate": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetTokenAccountsByOwner:
    def __init__(
        self,
        account: Pubkey,
        filter_: Union[RpcTokenAccountsFilterMint, RpcTokenAccountsFilterProgramId],
        config: Optional[RpcAccountInfoConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def account(self) -> Pubkey: ...
    @property
    def filter_(
        self,
    ) -> Union[RpcTokenAccountsFilterMint, RpcTokenAccountsFilterProgramId]: ...
    @property
    def config(self) -> Optional[RpcAccountInfoConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetTokenAccountsByOwner": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetTokenAccountsByOwner": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetTokenLargestAccounts:
    def __init__(
        self,
        mint: Pubkey,
        commitment: Optional[CommitmentLevel] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def mint(self) -> Pubkey: ...
    @property
    def commitment(self) -> Optional[CommitmentLevel]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetTokenLargestAccounts": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetTokenLargestAccounts": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetTokenSupply:
    def __init__(
        self,
        mint: Pubkey,
        commitment: Optional[CommitmentLevel] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def mint(self) -> Pubkey: ...
    @property
    def commitment(self) -> Optional[CommitmentLevel]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetTokenSupply": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetTokenSupply": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetTransaction:
    def __init__(
        self,
        signature: Signature,
        config: Optional[RpcTransactionConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def signature(self) -> Signature: ...
    @property
    def config(self) -> Optional[RpcTransactionConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetTransaction": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetTransaction": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetTransactionCount:
    def __init__(
        self, config: Optional[RpcContextConfig] = None, id: Optional[int] = None
    ): ...
    @property
    def config(self) -> Optional[RpcContextConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetTransactionCount": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetTransactionCount": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetVoteAccounts:
    def __init__(
        self,
        config: Optional[RpcGetVoteAccountsConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def config(self) -> Optional[RpcGetVoteAccountsConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetVoteAccounts": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetVoteAccounts": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class IsBlockhashValid:
    def __init__(
        self,
        blockhash: Hash,
        config: Optional[RpcContextConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def blockhash(self) -> Hash: ...
    @property
    def config(self) -> Optional[RpcContextConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "IsBlockhashValid": ...
    @staticmethod
    def from_bytes(data: bytes) -> "IsBlockhashValid": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RequestAirdrop:
    def __init__(
        self,
        pubkey: Pubkey,
        lamports: int,
        config: Optional[RpcRequestAirdropConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def pubkey(self) -> Pubkey: ...
    @property
    def lamports(self) -> int: ...
    @property
    def config(self) -> Optional[RpcRequestAirdropConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "RequestAirdrop": ...
    @staticmethod
    def from_bytes(data: bytes) -> "RequestAirdrop": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SendLegacyTransaction:
    def __init__(
        self,
        tx: Transaction,
        config: Optional[RpcSendTransactionConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def tx(self) -> Transaction: ...
    @property
    def config(self) -> Optional[RpcSendTransactionConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "SendLegacyTransaction": ...
    @staticmethod
    def from_bytes(data: bytes) -> "SendLegacyTransaction": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SendRawTransaction:
    def __init__(
        self,
        tx: Union[bytes, Sequence[int]],
        config: Optional[RpcSendTransactionConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def tx(self) -> List[int]: ...
    @property
    def config(self) -> Optional[RpcSendTransactionConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "SendRawTransaction": ...
    @staticmethod
    def from_bytes(data: bytes) -> "SendRawTransaction": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SendVersionedTransaction:
    def __init__(
        self,
        tx: VersionedTransaction,
        config: Optional[RpcSendTransactionConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def tx(self) -> VersionedTransaction: ...
    @property
    def config(self) -> Optional[RpcSendTransactionConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "SendVersionedTransaction": ...
    @staticmethod
    def from_bytes(data: bytes) -> "SendVersionedTransaction": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SimulateTransaction:
    def __init__(
        self,
        tx: Transaction,
        config: Optional[RpcSimulateTransactionConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def tx(self) -> Transaction: ...
    @property
    def config(self) -> Optional[RpcSimulateTransactionConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "SimulateTransaction": ...
    @staticmethod
    def from_bytes(data: bytes) -> "SimulateTransaction": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class ValidatorExit:
    def __init__(self, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "ValidatorExit": ...
    @staticmethod
    def from_bytes(data: bytes) -> "ValidatorExit": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class AccountSubscribe:
    def __init__(
        self,
        account: Pubkey,
        config: Optional[RpcAccountInfoConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def account(self) -> Pubkey: ...
    @property
    def config(self) -> Optional[RpcAccountInfoConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "AccountSubscribe": ...
    @staticmethod
    def from_bytes(data: bytes) -> "AccountSubscribe": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class BlockSubscribe:
    def __init__(
        self,
        filter_: Union[RpcBlockSubscribeFilter, RpcBlockSubscribeFilterMentions],
        config: Optional[RpcBlockSubscribeConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def filter_(
        self,
    ) -> Union[RpcBlockSubscribeFilter, RpcBlockSubscribeFilterMentions]: ...
    @property
    def config(self) -> Optional[RpcBlockSubscribeConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "BlockSubscribe": ...
    @staticmethod
    def from_bytes(data: bytes) -> "BlockSubscribe": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class LogsSubscribe:
    def __init__(
        self,
        filter_: Union[RpcTransactionLogsFilter, RpcTransactionLogsFilterMentions],
        config: Optional[RpcTransactionLogsConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def filter_(
        self,
    ) -> Union[RpcTransactionLogsFilter, RpcTransactionLogsFilterMentions]: ...
    @property
    def config(self) -> Optional[RpcTransactionLogsConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "LogsSubscribe": ...
    @staticmethod
    def from_bytes(data: bytes) -> "LogsSubscribe": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class ProgramSubscribe:
    def __init__(
        self,
        program: Pubkey,
        config: Optional[RpcProgramAccountsConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def program(self) -> Pubkey: ...
    @property
    def config(self) -> Optional[RpcProgramAccountsConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "ProgramSubscribe": ...
    @staticmethod
    def from_bytes(data: bytes) -> "ProgramSubscribe": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SignatureSubscribe:
    def __init__(
        self,
        signature: Signature,
        config: Optional[RpcSignatureSubscribeConfig] = None,
        id: Optional[int] = None,
    ): ...
    @property
    def signature(self) -> Signature: ...
    @property
    def config(self) -> Optional[RpcSignatureSubscribeConfig]: ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "SignatureSubscribe": ...
    @staticmethod
    def from_bytes(data: bytes) -> "SignatureSubscribe": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetClusterNodes:
    def __init__(self, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetClusterNodes": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetClusterNodes": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetEpochSchedule:
    def __init__(self, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetEpochSchedule": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetEpochSchedule": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetFirstAvailableBlock:
    def __init__(self, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetFirstAvailableBlock": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetFirstAvailableBlock": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetGenesisHash:
    def __init__(self, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetGenesisHash": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetGenesisHash": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetHealth:
    def __init__(self, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetHealth": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetHealth": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetHighestSnapshotSlot:
    def __init__(self, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetHighestSnapshotSlot": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetHighestSnapshotSlot": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetInflationRate:
    def __init__(self, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetInflationRate": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetInflationRate": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetMaxRetransmitSlot:
    def __init__(self, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetMaxRetransmitSlot": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetMaxRetransmitSlot": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetMaxShredInsertSlot:
    def __init__(self, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetMaxShredInsertSlot": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetMaxShredInsertSlot": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class GetVersion:
    def __init__(self, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "GetVersion": ...
    @staticmethod
    def from_bytes(data: bytes) -> "GetVersion": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class MinimumLedgerSlot:
    def __init__(self, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "MinimumLedgerSlot": ...
    @staticmethod
    def from_bytes(data: bytes) -> "MinimumLedgerSlot": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SlotSubscribe:
    def __init__(self, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "SlotSubscribe": ...
    @staticmethod
    def from_bytes(data: bytes) -> "SlotSubscribe": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SlotsUpdatesSubscribe:
    def __init__(self, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "SlotsUpdatesSubscribe": ...
    @staticmethod
    def from_bytes(data: bytes) -> "SlotsUpdatesSubscribe": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RootSubscribe:
    def __init__(self, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "RootSubscribe": ...
    @staticmethod
    def from_bytes(data: bytes) -> "RootSubscribe": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class VoteSubscribe:
    def __init__(self, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "VoteSubscribe": ...
    @staticmethod
    def from_bytes(data: bytes) -> "VoteSubscribe": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class AccountUnsubscribe:
    def __init__(self, subscription_id: int, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    @property
    def subscription_id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "AccountUnsubscribe": ...
    @staticmethod
    def from_bytes(data: bytes) -> "AccountUnsubscribe": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class BlockUnsubscribe:
    def __init__(self, subscription_id: int, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    @property
    def subscription_id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "BlockUnsubscribe": ...
    @staticmethod
    def from_bytes(data: bytes) -> "BlockUnsubscribe": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class LogsUnsubscribe:
    def __init__(self, subscription_id: int, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    @property
    def subscription_id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "LogsUnsubscribe": ...
    @staticmethod
    def from_bytes(data: bytes) -> "LogsUnsubscribe": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class ProgramUnsubscribe:
    def __init__(self, subscription_id: int, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    @property
    def subscription_id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "ProgramUnsubscribe": ...
    @staticmethod
    def from_bytes(data: bytes) -> "ProgramUnsubscribe": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SignatureUnsubscribe:
    def __init__(self, subscription_id: int, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    @property
    def subscription_id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "SignatureUnsubscribe": ...
    @staticmethod
    def from_bytes(data: bytes) -> "SignatureUnsubscribe": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SlotUnsubscribe:
    def __init__(self, subscription_id: int, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    @property
    def subscription_id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "SlotUnsubscribe": ...
    @staticmethod
    def from_bytes(data: bytes) -> "SlotUnsubscribe": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class SlotsUpdatesUnsubscribe:
    def __init__(self, subscription_id: int, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    @property
    def subscription_id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "SlotsUpdatesUnsubscribe": ...
    @staticmethod
    def from_bytes(data: bytes) -> "SlotsUpdatesUnsubscribe": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class RootUnsubscribe:
    def __init__(self, subscription_id: int, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    @property
    def subscription_id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "RootUnsubscribe": ...
    @staticmethod
    def from_bytes(data: bytes) -> "RootUnsubscribe": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

class VoteUnsubscribe:
    def __init__(self, subscription_id: int, id: Optional[int] = None): ...
    @property
    def id(self) -> int: ...
    @property
    def subscription_id(self) -> int: ...
    def to_json(self) -> str: ...
    @staticmethod
    def from_json(raw: str) -> "VoteUnsubscribe": ...
    @staticmethod
    def from_bytes(data: bytes) -> "VoteUnsubscribe": ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __hash__(self) -> int: ...

Body = Union[
    GetAccountInfo,
    GetBalance,
    GetBlock,
    GetBlockHeight,
    GetBlockProduction,
    GetBlockCommitment,
    GetBlocks,
    GetBlocksWithLimit,
    GetBlockTime,
    GetClusterNodes,
    GetEpochInfo,
    GetEpochSchedule,
    GetFeeForMessage,
    GetFirstAvailableBlock,
    GetGenesisHash,
    GetHealth,
    GetHighestSnapshotSlot,
    GetIdentity,
    GetInflationGovernor,
    GetInflationRate,
    GetInflationReward,
    GetLargestAccounts,
    GetLatestBlockhash,
    GetLeaderSchedule,
    GetMaxRetransmitSlot,
    GetMaxShredInsertSlot,
    GetMinimumBalanceForRentExemption,
    GetMultipleAccounts,
    GetProgramAccounts,
    GetRecentPerformanceSamples,
    GetSignaturesForAddress,
    GetSignatureStatuses,
    GetSlot,
    GetSlotLeader,
    GetSlotLeaders,
    GetStakeActivation,
    GetSupply,
    GetTokenAccountBalance,
    GetTokenAccountsByDelegate,
    GetTokenAccountsByOwner,
    GetTokenLargestAccounts,
    GetTokenSupply,
    GetTransaction,
    GetTransactionCount,
    GetVersion,
    GetVoteAccounts,
    IsBlockhashValid,
    MinimumLedgerSlot,
    RequestAirdrop,
    SendLegacyTransaction,
    SendRawTransaction,
    SendVersionedTransaction,
    ValidatorExit,
    AccountSubscribe,
    BlockSubscribe,
    LogsSubscribe,
    ProgramSubscribe,
    SignatureSubscribe,
    SlotSubscribe,
    SlotsUpdatesSubscribe,
    RootSubscribe,
    VoteSubscribe,
    AccountUnsubscribe,
    BlockUnsubscribe,
    LogsUnsubscribe,
    ProgramUnsubscribe,
    SignatureUnsubscribe,
    SimulateTransaction,
    SlotUnsubscribe,
    SlotsUpdatesUnsubscribe,
    RootUnsubscribe,
    VoteUnsubscribe,
]

def batch_to_json(reqs: Sequence[Body]) -> str: ...
def batch_from_json(raw: str) -> List[Body]: ...
