# Generated by Django 3.1.3 on 2020-11-16 20:21

from ..fields import JSONField

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django_vr_payment.fields


class Migration(migrations.Migration):

    dependencies = [
        ('django_vr_payment', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='VRPaymentWebhook',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('last_modified', models.DateTimeField(auto_now=True, verbose_name='Last modified')),
                ('raw_headers', JSONField(help_text='response header as json', verbose_name='Headers')),
                ('webhook_type', models.CharField(help_text='The webhook type. Can be PAYMENT, REGISTRATION, RISK (and others in test…)', max_length=64, verbose_name='Webhook type')),
                ('webhook_action', models.CharField(blank=True, help_text='The webhook action. Only applies to REGISTRATION type (and others in test…)', max_length=64, null=True, verbose_name='Webhook action')),
                ('decrypted_body', JSONField(help_text='The decrypted request.body in JSON', verbose_name='Decrypted body')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='VRPaymentWebhookPaymentPayload',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('last_modified', models.DateTimeField(auto_now=True, verbose_name='Last modified')),
                ('http_status_code', models.IntegerField(help_text='response status code', verbose_name='HTTP status code')),
                ('url', models.URLField(help_text='request url', verbose_name='URL')),
                ('raw_headers', JSONField(help_text='response header as json', verbose_name='Headers')),
                ('raw_content', JSONField(help_text='response content as json', verbose_name='Content')),
                ('build_number', models.CharField(blank=True, help_text='Useful for support purposes.', max_length=255, null=True, verbose_name='API response build number')),
                ('ndc', models.CharField(blank=True, help_text='An internal unique identifier for the request.', max_length=65, null=True, verbose_name='ndc')),
                ('result_code', models.CharField(blank=True, help_text='Status Code from VR Payment. see content for description', max_length=11, null=True, verbose_name='VR Payment status code')),
                ('result_description', models.CharField(blank=True, help_text="A textual description explaining the result.code's meaning.", max_length=255, null=True, verbose_name='Result Description')),
                ('result_avs_response', models.CharField(blank=True, help_text='Contains the AVS response returned by the acquirer. It may include one the following result:A = Address does match, zip code does not matchZ = Address does not match, zip code does matchN = Address and zip code do not matchU = Technical or logical error. AVS cannot be applied on card or address (not UK or US issuer), issuer is not available, etc.F = Address and Postal Code Matches', max_length=1, null=True, verbose_name='Result avs response')),
                ('result_cvv_response', models.CharField(blank=True, help_text='Contains the CVV response returned by the acquirer.', max_length=1, null=True, verbose_name='Result cvv response')),
                ('result_details', JSONField(blank=True, help_text='A container for name value pair used for enriching the response with bank-specific response details. I.e. the actual parameters used within resultDetails are bank-specific.', null=True, verbose_name='Result details')),
                ('result_details_acquirer_response', JSONField(blank=True, help_text='Represents the acquirer original response code retrieved from the acquirer directly.', null=True, verbose_name='Result details - Acquirer response')),
                ('card_bin', models.CharField(blank=True, help_text='The first six digits of the card.number', max_length=6, null=True, verbose_name='Card bin')),
                ('card_holder', models.CharField(blank=True, help_text='Holder of the credit card account', max_length=6, null=True, verbose_name='Card holder')),
                ('card_expiry_month', models.CharField(blank=True, help_text='The expiry month of the card', max_length=2, null=True, verbose_name='Card expiry month')),
                ('card_expiry_year', models.CharField(blank=True, help_text='The expiry year of the card', max_length=4, null=True, verbose_name='Card expiry year')),
                ('merchant_bank_account_holder', models.CharField(blank=True, help_text="Holder of the merchant's bank account", max_length=128, null=True, verbose_name='Merchant bank account holder')),
                ('merchant_bank_account_nummber', models.CharField(blank=True, help_text="The account number of the merchant's bank account. (IBAN for SEPA accounts)", max_length=64, null=True, verbose_name='Merchant bank account nummber')),
                ('merchant_bank_account_bic', models.CharField(blank=True, help_text="The BIC (Bank Identifier Code (SWIFT)) number of the merchant's bank account.", max_length=11, null=True, verbose_name='Merchant bank account bic')),
                ('merchant_bank_account_country', models.CharField(blank=True, help_text="The country code of the merchant's bank account (ISO 3166-1).", max_length=2, null=True, verbose_name='Merchant bank account country')),
                ('vr_pay_id', models.CharField(blank=True, help_text='The VR Pay identifier of this object', max_length=48, null=True, verbose_name='ID')),
                ('reference_id', models.CharField(blank=True, help_text='In case of referenced payment (e.g., Capture or Refund), this fields included to see which payment was referenced.', max_length=32, null=True, validators=[django.core.validators.RegexValidator(regex='[a-zA-Z0-9]{32}')], verbose_name='ReferenceID')),
                ('payment_brand', models.CharField(blank=True, help_text='The payment brand of the request.', max_length=32, null=True, validators=[django.core.validators.RegexValidator(regex='[a-zA-Z0-9_] {1,32}')], verbose_name='Payment brand')),
                ('amount', django_vr_payment.fields.VRPaymentDecimalField(blank=True, decimal_places=2, help_text='The amount of the request', max_digits=12, null=True, verbose_name='Amount')),
                ('currency', models.CharField(default='EUR', help_text="The ISO 4217 currency code of the payment request's amount", max_length=3, null=True, verbose_name='Currency')),
                ('descriptor', models.CharField(blank=True, help_text='The descriptor of the request.', max_length=127, null=True, verbose_name='Descriptor')),
                ('risk_score', models.IntegerField(blank=True, help_text='Returns the score of the executed transaction risk checks. The value is a number from -99999 to +99999. Can be returned both for standalone risk requests and payment requests that include risk checks.', null=True, validators=[django.core.validators.MinValueValidator(-99999), django.core.validators.MaxValueValidator(99999)], verbose_name='Risk score')),
                ('merchant_transaction_id', models.CharField(help_text='Merchant-provided reference number, should be unique for your transactions. Some receivers require this ID. This identifier is often used for reconciliation.', max_length=255, validators=[django.core.validators.MinLengthValidator(8)], verbose_name='Merchant transaction ID')),
                ('other', JSONField(blank=True, help_text="The response can also contain each of the data structures listed above, such as 'customer' and 'billingAddress'.", null=True, verbose_name='Other')),
            ],
            options={
                'verbose_name': 'VR Payment Webhook Payload',
                'verbose_name_plural': 'VR Payment Webhook Payloads',
            },
        ),
        migrations.RemoveIndex(
            model_name='vrpaymentbasicpayment',
            name='vr_payment__merchan_9521ba_idx',
        ),
        migrations.RemoveIndex(
            model_name='vrpaymentbasicpayment',
            name='vr_payment__merchan_44f0b9_idx',
        ),
        migrations.AddField(
            model_name='vrpaymentbasicpaymentstatusresponse',
            name='merchant_transaction_id',
            field=models.CharField(default='replace_me', help_text='Merchant-provided reference number, should be unique for your transactions. Some receivers require this ID. This identifier is often used for reconciliation.', max_length=255, validators=[django.core.validators.MinLengthValidator(8)], verbose_name='Merchant transaction ID'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='vrpaymentcheckoutresponse',
            name='merchant_transaction_id',
            field=models.CharField(default='replace_me', help_text='Merchant-provided reference number, should be unique for your transactions. Some receivers require this ID. This identifier is often used for reconciliation.', max_length=255, validators=[django.core.validators.MinLengthValidator(8)], verbose_name='Merchant transaction ID'),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='vrpaymentbasicpaymentstatusresponse',
            name='other',
            field=JSONField(blank=True, help_text="The response can also contain each of the data structures listed above, such as 'customer' and 'billingAddress'.", null=True, verbose_name='Other'),
        ),
        migrations.AlterField(
            model_name='vrpaymentbasicpaymentstatusresponse',
            name='raw_content',
            field=JSONField(help_text='response content as json', verbose_name='Content'),
        ),
        migrations.AlterField(
            model_name='vrpaymentbasicpaymentstatusresponse',
            name='raw_headers',
            field=JSONField(help_text='response header as json', verbose_name='Headers'),
        ),
        migrations.AlterField(
            model_name='vrpaymentbasicpaymentstatusresponse',
            name='result_details',
            field=JSONField(blank=True, help_text='A container for name value pair used for enriching the response with bank-specific response details. I.e. the actual parameters used within resultDetails are bank-specific.', null=True, verbose_name='Result details'),
        ),
        migrations.AlterField(
            model_name='vrpaymentbasicpaymentstatusresponse',
            name='result_details_acquirer_response',
            field=JSONField(blank=True, help_text='Represents the acquirer original response code retrieved from the acquirer directly.', null=True, verbose_name='Result details - Acquirer response'),
        ),
        migrations.AlterField(
            model_name='vrpaymentcheckoutresponse',
            name='other',
            field=JSONField(blank=True, help_text="The response can also contain each of the data structures listed above, such as 'customer' and 'billingAddress'.", null=True, verbose_name='Other'),
        ),
        migrations.AlterField(
            model_name='vrpaymentcheckoutresponse',
            name='raw_content',
            field=JSONField(help_text='response content as json', verbose_name='Content'),
        ),
        migrations.AlterField(
            model_name='vrpaymentcheckoutresponse',
            name='raw_headers',
            field=JSONField(help_text='response header as json', verbose_name='Headers'),
        ),
        migrations.AlterField(
            model_name='vrpaymentcheckoutresponse',
            name='result_details',
            field=JSONField(blank=True, help_text='A container for name value pair used for enriching the response with bank-specific response details. I.e. the actual parameters used within resultDetails are bank-specific.', null=True, verbose_name='Result details'),
        ),
        migrations.AlterField(
            model_name='vrpaymentcheckoutresponse',
            name='result_details_acquirer_response',
            field=JSONField(blank=True, help_text='Represents the acquirer original response code retrieved from the acquirer directly.', null=True, verbose_name='Result details - Acquirer response'),
        ),
        migrations.AddIndex(
            model_name='vrpaymentbasicpayment',
            index=models.Index(fields=['merchant_transaction_id'], name='django_vr_p_merchan_fe8f32_idx'),
        ),
        migrations.AddIndex(
            model_name='vrpaymentbasicpayment',
            index=models.Index(fields=['merchant_invoice_id'], name='django_vr_p_merchan_106324_idx'),
        ),
        migrations.AddField(
            model_name='vrpaymentwebhookpaymentpayload',
            name='basic_payment',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='webhook_responses', to='django_vr_payment.vrpaymentbasicpayment', verbose_name='VR Payment Basic Checkouts'),
        ),
        migrations.AddField(
            model_name='vrpaymentwebhookpaymentpayload',
            name='webhook',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='payment_payload', to='django_vr_payment.vrpaymentwebhook', verbose_name='VR Payment Webhook Payload'),
        ),
    ]
