"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BandwidthPackage = exports.BandwidthPackageProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ga_generated_1 = require("./ga.generated");
Object.defineProperty(exports, "BandwidthPackageProperty", { enumerable: true, get: function () { return ga_generated_1.RosBandwidthPackage; } });
/**
 * A ROS resource type:  `ALIYUN::GA::BandwidthPackage`
 */
class BandwidthPackage extends ros.Resource {
    /**
     * Create a new `ALIYUN::GA::BandwidthPackage`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosBandwidthPackage = new ga_generated_1.RosBandwidthPackage(this, id, {
            bandwidthType: props.bandwidthType,
            cbnGeographicRegionIdB: props.cbnGeographicRegionIdB,
            type: props.type,
            cbnGeographicRegionIdA: props.cbnGeographicRegionIdA,
            autoUseCoupon: props.autoUseCoupon,
            pricingCycle: props.pricingCycle,
            chargeType: props.chargeType,
            bandwidth: props.bandwidth,
            ratio: props.ratio,
            duration: props.duration,
            autoPay: props.autoPay,
            billingType: props.billingType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosBandwidthPackage;
        this.attrAutoPay = rosBandwidthPackage.attrAutoPay;
        this.attrAutoUseCoupon = rosBandwidthPackage.attrAutoUseCoupon;
        this.attrBandwidth = rosBandwidthPackage.attrBandwidth;
        this.attrBandwidthPackageId = rosBandwidthPackage.attrBandwidthPackageId;
        this.attrBandwidthPackageName = rosBandwidthPackage.attrBandwidthPackageName;
        this.attrBandwidthType = rosBandwidthPackage.attrBandwidthType;
        this.attrBillingType = rosBandwidthPackage.attrBillingType;
        this.attrCbnGeographicRegionIdA = rosBandwidthPackage.attrCbnGeographicRegionIdA;
        this.attrCbnGeographicRegionIdB = rosBandwidthPackage.attrCbnGeographicRegionIdB;
        this.attrChargeType = rosBandwidthPackage.attrChargeType;
        this.attrPaymentType = rosBandwidthPackage.attrPaymentType;
        this.attrRatio = rosBandwidthPackage.attrRatio;
        this.attrType = rosBandwidthPackage.attrType;
    }
}
exports.BandwidthPackage = BandwidthPackage;
//# sourceMappingURL=data:application/json;base64,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