"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeScriptAsset = exports.JavaScriptAsset = exports.EsbuildAsset = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_s3_assets_1 = require("aws-cdk-lib/aws-s3-assets");
const constructs_1 = require("constructs");
const bundler_1 = require("./bundler");
/**
 * Represents a generic esbuild asset.
 *
 * You should always use `TypeScriptAsset` or `JavaScriptAsset`.
 *
 * @stability experimental
 */
class EsbuildAsset extends aws_s3_assets_1.Asset {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        const { assetHash, buildOptions: options = {}, } = props;
        const entryPoints = typeof props.entryPoints === 'string' ? [props.entryPoints] : props.entryPoints;
        const name = scope.node.path + constructs_1.Node.PATH_SEP + id;
        const absWorkingDir = options.absWorkingDir ?? process.cwd();
        const forceRelativeEntrypointPath = (entryPoint) => {
            if (!path_1.isAbsolute(entryPoint)) {
                return entryPoint;
            }
            const relativeEntryPoint = path_1.relative(absWorkingDir, entryPoint);
            if (relativeEntryPoint.startsWith('..') || path_1.isAbsolute(relativeEntryPoint)) {
                throw new Error(`${name}: Entry points must be part of the working directory. See \`buildOptions.absWorkingDir\` to set a working directory different to the current one.`);
            }
            return relativeEntryPoint;
        };
        const relativeEntryPoints = Array.isArray(entryPoints) ?
            entryPoints.map(forceRelativeEntrypointPath) :
            Object.fromEntries(Object.entries(entryPoints)
                .map(([out, entryPoint]) => ([out, forceRelativeEntrypointPath(entryPoint)])));
        const buildOptions = {
            bundle: true,
            ...options,
            absWorkingDir,
        };
        super(scope, id, {
            path: absWorkingDir,
            assetHash,
            assetHashType: assetHash ? aws_cdk_lib_1.AssetHashType.CUSTOM : aws_cdk_lib_1.AssetHashType.OUTPUT,
            bundling: new bundler_1.EsbuildBundler(relativeEntryPoints, {
                ...props,
                buildOptions,
            }),
        });
    }
}
exports.EsbuildAsset = EsbuildAsset;
_a = JSII_RTTI_SYMBOL_1;
EsbuildAsset[_a] = { fqn: "@mrgrain/cdk-esbuild.EsbuildAsset", version: "3.13.1" };
/**
 * Bundles the entry points and creates a CDK asset which is uploaded to the bootstrapped CDK S3 bucket during deployment.
 *
 * The asset can be used by other constructs.
 *
 * @stability stable
 */
class JavaScriptAsset extends EsbuildAsset {
}
exports.JavaScriptAsset = JavaScriptAsset;
_b = JSII_RTTI_SYMBOL_1;
JavaScriptAsset[_b] = { fqn: "@mrgrain/cdk-esbuild.JavaScriptAsset", version: "3.13.1" };
/**
 * Bundles the entry points and creates a CDK asset which is uploaded to the bootstrapped CDK S3 bucket during deployment.
 *
 * The asset can be used by other constructs.
 *
 * @stability stable
 */
class TypeScriptAsset extends EsbuildAsset {
}
exports.TypeScriptAsset = TypeScriptAsset;
_c = JSII_RTTI_SYMBOL_1;
TypeScriptAsset[_c] = { fqn: "@mrgrain/cdk-esbuild.TypeScriptAsset", version: "3.13.1" };
//# sourceMappingURL=data:application/json;base64,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