from typing import Tuple, List, Optional

from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.migrations.state import ProjectState
from django.db.migrations.operations.base import Operation

class Migration:
    operations: List[Operation] = ...
    dependencies: List[Tuple[str, str]] = ...
    run_before: List[Tuple[str, str]] = ...
    replaces: List[Tuple[str, str]] = ...
    initial: Optional[bool] = ...
    atomic: bool = ...
    name: str = ...
    app_label: str = ...
    def __init__(self, name: str, app_label: str) -> None: ...
    def mutate_state(self, project_state: ProjectState, preserve: bool = ...) -> ProjectState: ...
    def apply(
        self, project_state: ProjectState, schema_editor: BaseDatabaseSchemaEditor, collect_sql: bool = ...
    ) -> ProjectState: ...
    def unapply(
        self, project_state: ProjectState, schema_editor: BaseDatabaseSchemaEditor, collect_sql: bool = ...
    ) -> ProjectState: ...

class SwappableTuple(Tuple[str, str]):
    setting: str = ...
    def __new__(cls, value: Tuple[str, str], setting: str) -> SwappableTuple: ...

def swappable_dependency(value: str) -> SwappableTuple: ...
