"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessLogFormat = exports.AccessLogField = exports.LogGroupLogDestination = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use CloudWatch Logs as a custom access log destination for API Gateway.
 */
class LogGroupLogDestination {
    constructor(logGroup) {
        this.logGroup = logGroup;
    }
    /**
     * Binds this destination to the CloudWatch Logs.
     */
    bind(_stage) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigateway_IStage(_stage);
        return {
            destinationArn: this.logGroup.logGroupArn,
        };
    }
}
exports.LogGroupLogDestination = LogGroupLogDestination;
_a = JSII_RTTI_SYMBOL_1;
LogGroupLogDestination[_a] = { fqn: "@aws-cdk/aws-apigateway.LogGroupLogDestination", version: "1.150.0" };
/**
 * $context variables that can be used to customize access log pattern.
 */
class AccessLogField {
    /**
     * The API owner's AWS account ID.
     */
    static contextAccountId() {
        return '$context.identity.accountId';
    }
    /**
     * The identifier API Gateway assigns to your API.
     */
    static contextApiId() {
        return '$context.apiId';
    }
    /**
     * A property of the claims returned from the Amazon Cognito user pool after the method caller is successfully authenticated.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html
     *
     * @param property A property key of the claims.
     */
    static contextAuthorizerClaims(property) {
        return `$context.authorizer.claims.${property}`;
    }
    /**
     * The principal user identification associated with the token sent by the client and returned
     * from an API Gateway Lambda authorizer (formerly known as a custom authorizer).
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html
     */
    static contextAuthorizerPrincipalId() {
        return '$context.authorizer.principalId';
    }
    /**
     * The stringified value of the specified key-value pair of the `context` map returned from an API Gateway Lambda authorizer function.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html
     * @param property key of the context map.
     */
    static contextAuthorizer(property) {
        return `$context.authorizer.${property}`;
    }
    /**
     * The AWS endpoint's request ID.
     */
    static contextAwsEndpointRequestId() {
        return '$context.awsEndpointRequestId';
    }
    /**
     * The full domain name used to invoke the API. This should be the same as the incoming `Host` header.
     */
    static contextDomainName() {
        return '$context.domainName';
    }
    /**
     * The first label of the `$context.domainName`. This is often used as a caller/customer identifier.
     */
    static contextDomainPrefix() {
        return '$context.domainPrefix';
    }
    /**
     * A string containing an API Gateway error message.
     */
    static contextErrorMessage() {
        return '$context.error.message';
    }
    /**
     * The quoted value of $context.error.message, namely "$context.error.message".
     */
    static contextErrorMessageString() {
        return '$context.error.messageString';
    }
    /**
     * A type of GatewayResponse. This variable can only be used for simple variable substitution in a GatewayResponse body-mapping template,
     * which is not processed by the Velocity Template Language engine, and in access logging.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-logging.html
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html
     */
    static contextErrorResponseType() {
        return '$context.error.responseType';
    }
    /**
     * A string containing a detailed validation error message.
     */
    static contextErrorValidationErrorString() {
        return '$context.error.validationErrorString';
    }
    /**
     * The extended ID that API Gateway assigns to the API request, which contains more useful information for debugging/troubleshooting.
     */
    static contextExtendedRequestId() {
        return '$context.extendedRequestId';
    }
    /**
     * The HTTP method used. Valid values include: `DELETE`, `GET`, `HEAD`, `OPTIONS`, `PATCH`, `POST`, and `PUT`.
     */
    static contextHttpMethod() {
        return '$context.httpMethod';
    }
    /**
     * The AWS account ID associated with the request.
     */
    static contextIdentityAccountId() {
        return '$context.identity.accountId';
    }
    /**
     * For API methods that require an API key, this variable is the API key associated with the method request.
     * For methods that don't require an API key, this variable is
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html
     */
    static contextIdentityApiKey() {
        return '$context.identity.apiKey';
    }
    /**
     * The API key ID associated with an API request that requires an API key.
     */
    static contextIdentityApiKeyId() {
        return '$context.identity.apiKeyId';
    }
    /**
     * The principal identifier of the caller making the request.
     */
    static contextIdentityCaller() {
        return '$context.identity.caller';
    }
    /**
     * The Amazon Cognito authentication provider used by the caller making the request.
     * Available only if the request was signed with Amazon Cognito credentials.
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-identity.html
     */
    static contextIdentityCognitoAuthenticationProvider() {
        return '$context.identity.cognitoAuthenticationProvider';
    }
    /**
     * The Amazon Cognito authentication type of the caller making the request.
     * Available only if the request was signed with Amazon Cognito credentials.
     */
    static contextIdentityCognitoAuthenticationType() {
        return '$context.identity.cognitoAuthenticationType';
    }
    /**
     * The Amazon Cognito identity ID of the caller making the request. Available only if the request was signed with Amazon Cognito credentials.
     */
    static contextIdentityCognitoIdentityId() {
        return '$context.identity.cognitoIdentityId';
    }
    /**
     * The Amazon Cognito identity pool ID of the caller making the request.
     * Available only if the request was signed with Amazon Cognito credentials.
     */
    static contextIdentityCognitoIdentityPoolId() {
        return '$context.identity.cognitoIdentityPoolId';
    }
    /**
     * The AWS organization ID.
     */
    static contextIdentityPrincipalOrgId() {
        return '$context.identity.principalOrgId';
    }
    /**
     * The source IP address of the TCP connection making the request to API Gateway.
     * Warning: You should not trust this value if there is any chance that the `X-Forwarded-For` header could be forged.
     */
    static contextIdentitySourceIp() {
        return '$context.identity.sourceIp';
    }
    /**
     * The principal identifier of the user making the request. Used in Lambda authorizers.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html
     */
    static contextIdentityUser() {
        return '$context.identity.user';
    }
    /**
     * The User-Agent header of the API caller.
     */
    static contextIdentityUserAgent() {
        return '$context.identity.userAgent';
    }
    /**
     * The Amazon Resource Name (ARN) of the effective user identified after authentication.
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html
     */
    static contextIdentityUserArn() {
        return '$context.identity.userArn';
    }
    /**
     * The request path.
     * For example, for a non-proxy request URL of https://{rest-api-id.execute-api.{region}.amazonaws.com/{stage}/root/child,
     * this value is /{stage}/root/child.
     */
    static contextPath() {
        return '$context.path';
    }
    /**
     * The request protocol, for example, HTTP/1.1.
     */
    static contextProtocol() {
        return '$context.protocol';
    }
    /**
     * The ID that API Gateway assigns to the API request.
     */
    static contextRequestId() {
        return '$context.requestId';
    }
    /**
     * The request header override.
     * If this parameter is defined, it contains the headers to be used instead of the HTTP Headers that are defined in the Integration Request pane.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
     *
     * @param headerName
     */
    static contextRequestOverrideHeader(headerName) {
        return `$context.requestOverride.header.${headerName}`;
    }
    /**
     * The request path override. If this parameter is defined,
     * it contains the request path to be used instead of the URL Path Parameters that are defined in the Integration Request pane.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
     *
     * @param pathName
     */
    static contextRequestOverridePath(pathName) {
        return `$context.requestOverride.path.${pathName}`;
    }
    /**
     * The request query string override.
     * If this parameter is defined, it contains the request query strings to be used instead
     * of the URL Query String Parameters that are defined in the Integration Request pane.
     *
     * @param querystringName
     */
    static contextRequestOverrideQuerystring(querystringName) {
        return `$context.requestOverride.querystring.${querystringName}`;
    }
    /**
     * The response header override.
     * If this parameter is defined, it contains the header to be returned instead of the Response header
     * that is defined as the Default mapping in the Integration Response pane.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
     *
     * @param headerName
     */
    static contextResponseOverrideHeader(headerName) {
        return `$context.responseOverride.header.${headerName}`;
    }
    /**
     * The response status code override.
     * If this parameter is defined, it contains the status code to be returned instead of the Method response status
     * that is defined as the Default mapping in the Integration Response pane.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
     */
    static contextResponseOverrideStatus() {
        return '$context.responseOverride.status';
    }
    /**
     * The CLF-formatted request time (dd/MMM/yyyy:HH:mm:ss +-hhmm).
     */
    static contextRequestTime() {
        return '$context.requestTime';
    }
    /**
     * The Epoch-formatted request time.
     */
    static contextRequestTimeEpoch() {
        return '$context.requestTimeEpoch';
    }
    /**
     * The identifier that API Gateway assigns to your resource.
     */
    static contextResourceId() {
        return '$context.resourceId';
    }
    /**
     * The path to your resource.
     * For example, for the non-proxy request URI of `https://{rest-api-id.execute-api.{region}.amazonaws.com/{stage}/root/child`,
     * The $context.resourcePath value is `/root/child`.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-create-api-step-by-step.html
     */
    static contextResourcePath() {
        return '$context.resourcePath';
    }
    /**
     * The deployment stage of the API request (for example, `Beta` or `Prod`).
     */
    static contextStage() {
        return '$context.stage';
    }
    /**
     * The response received from AWS WAF: `WAF_ALLOW` or `WAF_BLOCK`. Will not be set if the stage is not associated with a web ACL.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-control-access-aws-waf.html
     */
    static contextWafResponseCode() {
        return '$context.wafResponseCode';
    }
    /**
     * The complete ARN of the web ACL that is used to decide whether to allow or block the request.
     * Will not be set if the stage is not associated with a web ACL.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-control-access-aws-waf.html
     */
    static contextWebaclArn() {
        return '$context.webaclArn';
    }
    /**
     * The trace ID for the X-Ray trace.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-enabling-xray.html
     */
    static contextXrayTraceId() {
        return '$context.xrayTraceId';
    }
    /**
     * The authorizer latency in ms.
     */
    static contextAuthorizerIntegrationLatency() {
        return '$context.authorizer.integrationLatency';
    }
    /**
     * The integration latency in ms.
     */
    static contextIntegrationLatency() {
        return '$context.integrationLatency';
    }
    /**
     * For Lambda proxy integration, this parameter represents the status code returned from AWS Lambda,
     * not from the backend Lambda function.
     */
    static contextIntegrationStatus() {
        return '$context.integrationStatus';
    }
    /**
     * The response latency in ms.
     */
    static contextResponseLatency() {
        return '$context.responseLatency';
    }
    /**
     * The response payload length.
     */
    static contextResponseLength() {
        return '$context.responseLength';
    }
    /**
     * The method response status.
     */
    static contextStatus() {
        return '$context.status';
    }
}
exports.AccessLogField = AccessLogField;
_b = JSII_RTTI_SYMBOL_1;
AccessLogField[_b] = { fqn: "@aws-cdk/aws-apigateway.AccessLogField", version: "1.150.0" };
/**
 * factory methods for access log format.
 */
class AccessLogFormat {
    constructor(format) {
        this.format = format;
    }
    /**
     * Custom log format.
     * You can create any log format string. You can easily get the $ context variable by using the methods of AccessLogField.
     * @param format
     * @example
     *
     *  apigateway.AccessLogFormat.custom(JSON.stringify({
     *      requestId: apigateway.AccessLogField.contextRequestId(),
     *      sourceIp: apigateway.AccessLogField.contextIdentitySourceIp(),
     *      method: apigateway.AccessLogField.contextHttpMethod(),
     *      userContext: {
     *        sub: apigateway.AccessLogField.contextAuthorizerClaims('sub'),
     *        email: apigateway.AccessLogField.contextAuthorizerClaims('email')
     *      }
     *   }))
     */
    static custom(format) {
        return new AccessLogFormat(format);
    }
    /**
     * Generate Common Log Format.
     */
    static clf() {
        const requester = [AccessLogField.contextIdentitySourceIp(), AccessLogField.contextIdentityCaller(), AccessLogField.contextIdentityUser()].join(' ');
        const requestTime = AccessLogField.contextRequestTime();
        const request = [AccessLogField.contextHttpMethod(), AccessLogField.contextResourcePath(), AccessLogField.contextProtocol()].join(' ');
        const status = [AccessLogField.contextStatus(), AccessLogField.contextResponseLength(), AccessLogField.contextRequestId()].join(' ');
        return new AccessLogFormat(`${requester} [${requestTime}] "${request}" ${status}`);
    }
    /**
     * Access log will be produced in the JSON format with a set of fields most useful in the access log. All fields are turned on by default with the
     * option to turn off specific fields.
     */
    static jsonWithStandardFields(fields = {
        ip: true,
        user: true,
        caller: true,
        requestTime: true,
        httpMethod: true,
        resourcePath: true,
        status: true,
        protocol: true,
        responseLength: true,
    }) {
        jsiiDeprecationWarnings._aws_cdk_aws_apigateway_JsonWithStandardFieldProps(fields);
        return this.custom(JSON.stringify({
            requestId: AccessLogField.contextRequestId(),
            ip: fields.ip ? AccessLogField.contextIdentitySourceIp() : undefined,
            user: fields.user ? AccessLogField.contextIdentityUser() : undefined,
            caller: fields.caller ? AccessLogField.contextIdentityCaller() : undefined,
            requestTime: fields.requestTime ? AccessLogField.contextRequestTime() : undefined,
            httpMethod: fields.httpMethod ? AccessLogField.contextHttpMethod() : undefined,
            resourcePath: fields.resourcePath ? AccessLogField.contextResourcePath() : undefined,
            status: fields.status ? AccessLogField.contextStatus() : undefined,
            protocol: fields.protocol ? AccessLogField.contextProtocol() : undefined,
            responseLength: fields.responseLength ? AccessLogField.contextResponseLength() : undefined,
        }));
    }
    /**
     * Output a format string to be used with CloudFormation.
     */
    toString() {
        return this.format;
    }
}
exports.AccessLogFormat = AccessLogFormat;
_c = JSII_RTTI_SYMBOL_1;
AccessLogFormat[_c] = { fqn: "@aws-cdk/aws-apigateway.AccessLogFormat", version: "1.150.0" };
//# sourceMappingURL=data:application/json;base64,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