# Generated by Django 3.1.5 on 2021-01-22 11:32

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('geostore', '0044_auto_20201106_1638'),
        ('terra_geocrud', '0059_auto_20201022_0930'),
    ]

    operations = [
        migrations.CreateModel(
            name='RoutingSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(help_text='Label that will be shown on the list', max_length=250)),
                ('provider', models.CharField(choices=[('mapbox', 'Mapbox'), ('geostore', 'Geostore')], help_text="Provider's name", max_length=250)),
                ('mapbox_transit', models.CharField(blank=True, choices=[('driving', 'Driving'), ('walking', 'Walking'), ('cycling', 'Cycling')], help_text='Mabox transit', max_length=250)),
                ('crud_view', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='routing_settings', to='terra_geocrud.crudview')),
                ('layer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='routing_settings', to='geostore.layer')),
            ],
        ),
        migrations.AddConstraint(
            model_name='routingsettings',
            constraint=models.UniqueConstraint(condition=models.Q(layer__isnull=False), fields=('provider', 'layer'), name='check_provider_layer'),
        ),
        migrations.AddConstraint(
            model_name='routingsettings',
            constraint=models.UniqueConstraint(condition=models.Q(_negated=True, mapbox_transit=''), fields=('provider', 'mapbox_transit'), name='check_provider_mapbox_transit'),
        ),
        migrations.AlterUniqueTogether(
            name='routingsettings',
            unique_together={('label', 'crud_view'), ('layer', 'crud_view')},
        ),
    ]
