# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-11-26 13:22


from django.db import migrations


def rename_admin_groups(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    Group = apps.get_model('auth', 'Group')
    try:
        group = Group.objects.get(pk=1)
        group.name = 'admin'
        group.save()

    except Exception:
        pass


class Migration(migrations.Migration):

    dependencies = [
        ('managements', '0002_auto_20181105_2023'),
    ]

    operations = [
        migrations.RunPython(rename_admin_groups, reverse_code=migrations.RunPython.noop),
    ]
