# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-11-04 10:50


from django.db import migrations
import datetime


class Migration(migrations.Migration):

    dependencies = [
        ('courses', '0006_coursefile_seconds'),
    ]

    def convert_to_seconds(apps, schema_editor):

        Object = apps.get_model('courses', 'CourseFile')
        for obj in Object.objects.all():
            obj.seconds = datetime.timedelta(hours=obj.time.hour, minutes=obj.time.minute,
                                              seconds=obj.time.second).total_seconds()
            obj.save()

    operations = [
        migrations.RunPython(convert_to_seconds, reverse_code=migrations.RunPython.noop),
    ]
