# Generated by Django 2.2 on 2021-09-04 11:15

from django.db import migrations, models
import django.db.models.deletion


def add_records(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    Course = apps.get_model('courses', 'Course')
    TeacherCourse = apps.get_model('courses', 'TeacherCourse')
    items = [
        TeacherCourse(
            course_obj_id=pk,
            teacher_obj_id=teacher_pk
        )
        for pk, teacher_pk, in Course.objects.filter(teacher_obj__isnull=False).values_list('pk', 'teacher_obj__pk')
    ]

    TeacherCourse.objects.bulk_create(items)


def remove_records(apps, schema_editor):
    '''
    We can't import the Post model directly as it may be a newer
    version than this migration expects. We use the historical version.
    '''
    TeacherCourse = apps.get_model('courses', 'TeacherCourse')

    TeacherCourse.objects.all().delete()


class Migration(migrations.Migration):
    dependencies = [
        ('teachers', '0003_auto_20181028_2116'),
        ('courses', '0022_coursefilesegment'),
    ]

    operations = [
        migrations.CreateModel(
            name='TeacherCourse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('priority', models.PositiveIntegerField(default=0, verbose_name='Priority')),
                ('course_obj', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='courses.Course',
                                                 verbose_name='دوره')),
                ('teacher_obj', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='teachers.Teacher',
                                                  verbose_name='مدرس')),
            ],
            options={
                'verbose_name': 'Teacher course',
                'verbose_name_plural': 'Teacher course relations',
            },
        ),
        migrations.AddField(
            model_name='course',
            name='teachers_temporary',
            field=models.ManyToManyField(blank=True, related_name='course_temporary', through='courses.TeacherCourse',
                                         to='teachers.Teacher', verbose_name='مدرسین'),
        ),
        migrations.RunPython(add_records, reverse_code=remove_records),
        migrations.RemoveField(
            model_name='course',
            name='teacher_obj',
        ),
        migrations.RemoveField(
            model_name='course',
            name='teachers_temporary',
        ),
        migrations.AddField(
            model_name='course',
            name='teacher_obj',
            field=models.ManyToManyField(blank=True, through='courses.TeacherCourse', to='teachers.Teacher',
                                         verbose_name='مدرسین'),
        ),
        migrations.AlterModelOptions(
            name='teachercourse',
            options={'ordering': ['priority'], 'verbose_name': 'Teacher course',
                     'verbose_name_plural': 'Teacher course relations'},
        ),
        migrations.AlterUniqueTogether(
            name='teachercourse',
            unique_together={('course_obj', 'teacher_obj')},
        ),
    ]
