# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-10-25 15:43


from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('basemodels', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('province', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='BaseEducation',
            fields=[
                ('basemodel_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='basemodels.BaseModel')),
                ('is_published', models.BooleanField(default=False, verbose_name='Published')),
            ],
            options={
                'verbose_name': 'Base Education',
                'verbose_name_plural': 'Base Education',
            },
            bases=('basemodels.basemodel',),
        ),
        migrations.CreateModel(
            name='CityInstitute',
            fields=[
                ('baseeducation_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='educations.BaseEducation')),
            ],
            options={
                'verbose_name': 'CityInstitute',
                'verbose_name_plural': 'CityInstitutes',
            },
            bases=('educations.baseeducation',),
        ),
        migrations.CreateModel(
            name='Degree',
            fields=[
                ('baseeducation_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='educations.BaseEducation')),
                ('name', models.CharField(max_length=50, verbose_name='Title')),
            ],
            options={
                'verbose_name': 'Degree',
                'verbose_name_plural': 'Degrees',
            },
            bases=('educations.baseeducation',),
        ),
        migrations.CreateModel(
            name='Education',
            fields=[
                ('baseeducation_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='educations.BaseEducation')),
                ('receive_date', models.DateTimeField(null=True, verbose_name='Receive Date')),
                ('average', models.FloatField(max_length=3, null=True, verbose_name='Average')),
                ('description', models.TextField(blank=True, max_length=200, null=True, verbose_name='Descritpion')),
                ('degree_obj', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='educations.Degree', verbose_name='Degree')),
            ],
            options={
                'verbose_name': 'Education',
                'verbose_name_plural': 'Educations',
            },
            bases=('educations.baseeducation',),
        ),
        migrations.CreateModel(
            name='FieldSubject',
            fields=[
                ('baseeducation_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='educations.BaseEducation')),
                ('name', models.CharField(max_length=50, verbose_name='Title')),
                ('parent_obj', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='educations.FieldSubject', verbose_name='Parent Field Subject')),
            ],
            options={
                'verbose_name': 'Field Subject',
                'verbose_name_plural': 'Field Subjects',
            },
            bases=('educations.baseeducation',),
        ),
        migrations.CreateModel(
            name='Institute',
            fields=[
                ('baseeducation_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='educations.BaseEducation')),
                ('name', models.CharField(max_length=40, verbose_name='Institute Name')),
                ('cities', models.ManyToManyField(through='educations.CityInstitute', to='province.City')),
            ],
            options={
                'verbose_name': 'Institute',
                'verbose_name_plural': 'Institutes',
            },
            bases=('educations.baseeducation',),
        ),
        migrations.AddField(
            model_name='education',
            name='field_subject_obj',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='educations.FieldSubject', verbose_name='Field Subject'),
        ),
        migrations.AddField(
            model_name='education',
            name='institute_obj',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='educations.Institute', verbose_name='Institute'),
        ),
        migrations.AddField(
            model_name='education',
            name='user_obj',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User'),
        ),
        migrations.AddField(
            model_name='cityinstitute',
            name='Institute',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='educations.Institute', verbose_name='Institude'),
        ),
        migrations.AddField(
            model_name='cityinstitute',
            name='city',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='province.City', verbose_name='City'),
        ),
    ]
