# =============================================================================== #
#                                                                                 #
#    This file has been generated automatically!! Do not change this manually!    #
#                                                                                 #
# =============================================================================== #
from __future__ import annotations

from pydantic import Field

from ..base_object import BaseObject


class LocalFile(BaseObject):
    """
    Represents a local file
    
    :param path: Local path to the locally available file part; may be empty
    :type path: :class:`str`
    
    :param can_be_downloaded: True, if it is possible to try to download or generate the file
    :type can_be_downloaded: :class:`bool`
    
    :param can_be_deleted: True, if the file can be deleted
    :type can_be_deleted: :class:`bool`
    
    :param is_downloading_active: True, if the file is currently being downloaded (or a local copy is being generated by some other means)
    :type is_downloading_active: :class:`bool`
    
    :param is_downloading_completed: True, if the local copy is fully available
    :type is_downloading_completed: :class:`bool`
    
    :param download_offset: Download will be started from this offset. downloaded_prefix_size is calculated from this offset
    :type download_offset: :class:`int`
    
    :param downloaded_prefix_size: If is_downloading_completed is false, then only some prefix of the file starting from download_offset is ready to be read. downloaded_prefix_size is the size of that prefix in bytes
    :type downloaded_prefix_size: :class:`int`
    
    :param downloaded_size: Total downloaded file size, in bytes. Can be used only for calculating download progress. The actual file size may be bigger, and some parts of it may contain garbage
    :type downloaded_size: :class:`int`
    
    """

    ID: str = Field("localFile", alias="@type")
    path: str
    can_be_downloaded: bool
    can_be_deleted: bool
    is_downloading_active: bool
    is_downloading_completed: bool
    download_offset: int
    downloaded_prefix_size: int
    downloaded_size: int

    @staticmethod
    def read(q: dict) -> LocalFile:
        return LocalFile.construct(**q)
