# Security Policy

Before reporting a security issue, please review our security policy.

## Checklist

- [ ] The security issue has not been previously reported.
- [ ] The security issue is not documented in the [security considerations](https://sereto.s4n.cz/getting_started/security_considerations/).
- [ ] The security issue is not caused by misconfiguration or misuse of the software.

## Reporting a Vulnerability

If you discover a security issue, please report it [here](https://github.com/s3r3t0/sereto/security/advisories/new).

When reporting a vulnerability, please provide the following information:

- A clear and concise description of the vulnerability.
- Steps to reproduce the vulnerability, including any specific configurations or inputs required.
- The version of the software where the vulnerability was found.
- Any additional information or context that may be helpful in understanding and reproducing the issue.

We take security reports seriously and will review them promptly. Once a vulnerability is confirmed, we will work diligently to fix it and release a patch as quickly as possible.

## Preferred Languages

We kindly request that all communications regarding security issues be conducted in **English**.

## Bounty Program

Please note that our software is a **non-profit** open source project. **We do not have a bounty program** in place and therefore, we are unable to offer any monetary rewards for security reports.

However, we greatly appreciate any security reports and contributions from the community. Your efforts help us improve the security of our software and ensure a safer experience for all users.

Thank you for your understanding and for helping us make our software more secure.
