# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pygt3x']

package_data = \
{'': ['*']}

install_requires = \
['numpy>=1.21.2', 'pandas>=1.2.5']

setup_kwargs = {
    'name': 'pygt3x',
    'version': '0.4.2',
    'description': 'Python module for reading GT3X/AGDC file format data',
    'long_description': '# pygt3x\n![Tests](https://github.com/actigraph/pygt3x/actions/workflows/tests.yml/badge.svg)\n\nPython module for reading GT3X/AGDC file format data generated by ActiGraph devices.\n\n## Example Usage\n\nTo read calibrated accelerometer data, you can use the code snippet below:\n\n```python\nfrom pygt3x.reader import FileReader\nfrom pygt3x.calibration import CalibratedReader\n\n# Read raw data and calibrate\n# Dump to pandas data frame\nwith FileReader("FILENAME") as reader:\n    calibrated_reader = CalibratedReader(reader)\n    df = calibrated_reader.to_pandas()\n    \n    # After reading a file, idle sleep mode status can be obtained\n    was_idle_sleep_mode_used = reader.idle_sleep_mode_activated\n    print(df.head(5))\n```\n\nIf your AGDC file contains temperature data, you can read it using:\n\n```python\nfrom pygt3x.reader import FileReader\nfrom pygt3x.calibration import CalibratedReader\n\nwith FileReader("FILENAME") as reader:\n    calibrated_reader = CalibratedReader(reader)\n    df = calibrated_reader.temperature_to_pandas()\n    print(df.head(5))\n```',
    'author': 'Mark Fogle',
    'author_email': 'mark.fogle@theactigraph.com',
    'maintainer': 'Ali Neishabouri',
    'maintainer_email': 'ali.neishabouri@theactigraph.com',
    'url': 'https://github.com/actigraph/pygt3x',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8.1,<3.12',
}


setup(**setup_kwargs)
