"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'aws-cdk-sqs');
const dlq = new lib_1.Queue(stack, 'DeadLetterQueue');
const queue = new lib_1.Queue(stack, 'Queue', {
    deadLetterQueue: { queue: dlq, maxReceiveCount: 5 }
});
new lib_1.Queue(stack, 'FifoQueue', {
    fifo: true
});
new core_1.CfnOutput(stack, 'QueueUrl', { value: queue.queueUrl });
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuc3FzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuc3FzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsd0NBQXNEO0FBQ3RELGdDQUErQjtBQUUvQixNQUFNLEdBQUcsR0FBRyxJQUFJLFVBQUcsRUFBRSxDQUFDO0FBRXRCLE1BQU0sS0FBSyxHQUFHLElBQUksWUFBSyxDQUFDLEdBQUcsRUFBRSxhQUFhLENBQUMsQ0FBQztBQUU1QyxNQUFNLEdBQUcsR0FBRyxJQUFJLFdBQUssQ0FBQyxLQUFLLEVBQUUsaUJBQWlCLENBQUMsQ0FBQztBQUNoRCxNQUFNLEtBQUssR0FBRyxJQUFJLFdBQUssQ0FBQyxLQUFLLEVBQUUsT0FBTyxFQUFFO0lBQ3RDLGVBQWUsRUFBRSxFQUFFLEtBQUssRUFBRSxHQUFHLEVBQUUsZUFBZSxFQUFFLENBQUMsRUFBRTtDQUNwRCxDQUFDLENBQUM7QUFFSCxJQUFJLFdBQUssQ0FBQyxLQUFLLEVBQUUsV0FBVyxFQUFFO0lBQzVCLElBQUksRUFBRSxJQUFJO0NBQ1gsQ0FBQyxDQUFDO0FBRUgsSUFBSSxnQkFBUyxDQUFDLEtBQUssRUFBRSxVQUFVLEVBQUUsRUFBRSxLQUFLLEVBQUUsS0FBSyxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7QUFFNUQsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQXBwLCBDZm5PdXRwdXQsIFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBRdWV1ZSB9IGZyb20gJy4uL2xpYic7XG5cbmNvbnN0IGFwcCA9IG5ldyBBcHAoKTtcblxuY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soYXBwLCAnYXdzLWNkay1zcXMnKTtcblxuY29uc3QgZGxxID0gbmV3IFF1ZXVlKHN0YWNrLCAnRGVhZExldHRlclF1ZXVlJyk7XG5jb25zdCBxdWV1ZSA9IG5ldyBRdWV1ZShzdGFjaywgJ1F1ZXVlJywge1xuICBkZWFkTGV0dGVyUXVldWU6IHsgcXVldWU6IGRscSwgbWF4UmVjZWl2ZUNvdW50OiA1IH1cbn0pO1xuXG5uZXcgUXVldWUoc3RhY2ssICdGaWZvUXVldWUnLCB7XG4gIGZpZm86IHRydWVcbn0pO1xuXG5uZXcgQ2ZuT3V0cHV0KHN0YWNrLCAnUXVldWVVcmwnLCB7IHZhbHVlOiBxdWV1ZS5xdWV1ZVVybCB9KTtcblxuYXBwLnN5bnRoKCk7XG4iXX0=