/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Ace;
import Ace2.AceViewer;
import Ace2.AceViewerConfig;
import Ace2.AnnotationLoader;
import Ace2.Assembly;
import Ace2.AssemblyCanvas;
import Ace2.AssemblySequence;
import Ace2.ChromosomeDisambiguator;
import Ace2.Codon;
import Ace2.ErrorReporter;
import Ace2.Exon;
import Ace2.GeneInfo;
import Ace2.HeteroSummary;
import Ace2.JDBCCache;
import Ace2.PadMap;
import Ace2.PaddedNucleotideSearch;
import Ace2.RefGene;
import Ace2.SAMAssembly;
import Ace2.SAMRegion;
import Ace2.SAMResource;
import Ace2.SAMStreamingSNPFinder;
import Ace2.SAMUtils;
import Ace2.SNP;
import Ace2.SNP2;
import Ace2.SNPControl;
import Ace2.SNPList;
import Ace2.SearchWidget2;
import Funk.Gr;
import Funk.Message;
import Funk.Str;
import Funk.Timer;
import TCGA.MouseDragScroller;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AcePanel
extends JPanel
implements Observer,
ActionListener,
ItemListener,
KeyListener,
FocusListener,
MouseListener,
ChangeListener,
Runnable {
    AssemblyCanvas canvas;
    Ace ace;
    String filename;
    private boolean use_postgres = false;
    private static boolean snp_info = true;
    private String start_contig = "Contig1";
    private int start_offset = -1;
    private SNPList start_snps = null;
    private Hashtable all_snps = null;
    private Hashtable heterozygotes = null;
    private JButton b_best_snp;
    private JButton b_exit;
    private JButton b_help;
    private JButton b_find;
    private JTextField nav_field;
    private JComboBox choice_contigs;
    private JComboBox choice_exons;
    private JSpinner sp_exons;
    private JSpinner sp_snps;
    private AceViewerConfig config;
    private boolean is_built = false;
    private JPanel cp;
    private Observer deep_sigh;

    public AcePanel(AceViewerConfig config) {
        this.config = config;
        this.deep_sigh = this;
        this.setup();
        new Thread(this).start();
    }

    public void set_font_size(int size) {
        if (this.canvas != null) {
            this.canvas.set_font_size(size);
        }
    }

    public void find() {
        SearchWidget2 sw = new SearchWidget2(Gr.getJFrame(this));
        if (sw.wants_find()) {
            String value = sw.get_value();
            System.err.println("find " + value);
            this.canvas.set_consensus_highlight(0, 0);
            if (sw.is_id_search()) {
                this.find_ids(value);
            } else {
                this.consensus_search(value);
            }
        }
    }

    public void update(Observable o, Object arg) {
        if (o instanceof SNPControl) {
            System.err.println("SNPControl!");
            this.find_snps();
        } else if (o instanceof AnnotationLoader) {
            this.init_exon_navigation();
            this.canvas.repaint();
        } else if (o instanceof Ace) {
            Ace a = (Ace)o;
            if (arg instanceof Integer) {
                if (this.canvas != null) {
                    this.canvas.repaint();
                }
            } else {
                boolean ok = (Boolean)arg;
                if (ok && !a.is_empty()) {
                    this.post_load();
                } else {
                    this.canvas.repaint();
                }
            }
        }
    }

    public void run() {
        boolean contig_setup = false;
        while (true) {
            if (!contig_setup && this.config.assembly.is_loaded()) {
                if (this.config.assembly.supports_contigs()) {
                    this.start_contig = this.config.ACE_AUTOCONTIG ? this.config.assembly.get_biggest_contig_id() : this.config.assembly.get_contig_id_list().get(0);
                    this.config.assembly.set_contig(this.start_contig);
                }
                contig_setup = true;
            }
            if (this.config.assembly.alignment_is_built()) break;
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.post_load();
    }

    public void setup() {
        JScrollBar hs = new JScrollBar(0);
        JScrollBar hv = new JScrollBar(1);
        this.addMouseListener(this);
        this.canvas = new AssemblyCanvas(this, this.config, hs, hv);
        this.addKeyListener(this);
        this.canvas.addKeyListener(this);
        MouseDragScroller mdc = new MouseDragScroller(this.canvas, hs, hv);
        mdc.set_drag_button_mask(this.config.DRAG_BUTTON_MASK);
        mdc.set_drag_scale_factor(this.config.DRAG_SCALE_FACTOR);
        this.cp = new JPanel();
        this.cp.setLayout(new BorderLayout());
        JPanel left_p = new JPanel();
        this.choice_contigs = new JComboBox();
        this.choice_contigs.addItem("Contig1");
        this.choice_contigs.addItemListener(this);
        if (this.config.assembly.supports_contigs()) {
            left_p.add(this.choice_contigs);
        }
        if (snp_info) {
            this.b_best_snp = new JButton("SNPs");
            left_p.add(this.b_best_snp);
            this.b_best_snp.setToolTipText("click to detect SNPs and indels");
            this.b_best_snp.addActionListener(this);
        }
        ArrayList<String> dummy = new ArrayList<String>();
        dummy.add("                   ");
        SpinnerListModel slm = new SpinnerListModel(dummy);
        this.sp_snps = new JSpinner(slm);
        this.sp_snps.setToolTipText("SNP/indel information");
        this.sp_snps.setVisible(false);
        JComponent editor = this.sp_snps.getEditor();
        if (editor instanceof JSpinner.ListEditor) {
            JFormattedTextField jtf = ((JSpinner.ListEditor)editor).getTextField();
            jtf.setHorizontalAlignment(2);
            jtf.setEditable(false);
        }
        left_p.add(this.sp_snps);
        this.sp_snps.setEnabled(false);
        this.sp_snps.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SNPList snps;
                SpinnerListModel slm = (SpinnerListModel)AcePanel.this.sp_snps.getModel();
                String entry = (String)slm.getValue();
                AcePanel.this.sp_snps.setToolTipText(entry);
                int index = 0;
                int idx = entry.indexOf(":");
                if (idx > -1) {
                    String number = entry.substring(1, idx);
                    index = Integer.parseInt(number) - 1;
                }
                if ((snps = ((AcePanel)AcePanel.this).config.assembly.get_snps()) != null) {
                    snps.set_index(index);
                    SNP snp = (SNP)snps.elementAt(index);
                    int cpos = snp.position;
                    ((AcePanel)AcePanel.this).config.clamp_cons_start = AcePanel.this.canvas.get_start_for_center(cpos);
                    AcePanel.this.canvas.center_on(cpos);
                    int loc = snps.current_location_id();
                    if (loc > 0 && AcePanel.this.heterozygotes != null) {
                        AcePanel.this.canvas.set_heterozygotes((Hashtable)AcePanel.this.heterozygotes.get(Integer.toString(loc)));
                    }
                }
            }
        });
        if (this.config.enable_exon_navigation) {
            this.choice_exons = new JComboBox();
            this.choice_exons.addItem("NM_000000");
            this.sp_exons = new JSpinner(new SpinnerListModel());
            left_p.add(new JLabel("    RefSeq:", 4));
            left_p.add(this.choice_exons);
            left_p.add(this.sp_exons);
            this.sp_exons.setToolTipText("exon number");
            this.choice_exons.setEnabled(false);
            this.sp_exons.setEnabled(false);
        }
        if (this.config.LOCAL_FILE_MODE) {
            left_p.add(new JLabel("    "));
            JLabel jl = new JLabel("Jump:", 4);
            left_p.add(jl);
            String help = "move to new location: enter gene symbol or position in format chrX:start-end";
            jl.setToolTipText(help);
            this.nav_field = new JTextField(10);
            left_p.add(this.nav_field);
            this.nav_field.setToolTipText(help);
            this.nav_field.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AcePanel.this.switch_assembly(AcePanel.this.nav_field.getText());
                }
            });
        }
        this.cp.add("West", left_p);
        JPanel right_p = new JPanel();
        this.b_find = new JButton("Find");
        right_p.add(this.b_find);
        this.b_find.addActionListener(this);
        this.cp.add("East", right_p);
        this.setLayout(new BorderLayout());
        this.add("North", this.cp);
        this.add("Center", this.canvas);
        this.add("East", hv);
        this.add("South", hs);
        this.addFocusListener(this);
        this.canvas.addFocusListener(this);
        this.cp.addFocusListener(this);
    }

    public void finalize() {
        System.out.println("ap finalize");
        this.canvas.finalize();
    }

    public void dispose() {
        System.out.println("ap dispose");
    }

    void snp_move(int direction) {
        SNPList snps = this.config.assembly.get_snps();
        if (snps != null) {
            if (direction > 0) {
                snps.move(direction);
            }
            int cpos = snps.current_position();
            this.config.clamp_cons_start = this.canvas.get_start_for_center(cpos);
            this.canvas.center_on(cpos);
            int loc = snps.current_location_id();
            if (loc > 0 && this.heterozygotes != null) {
                this.canvas.set_heterozygotes((Hashtable)this.heterozygotes.get(Integer.toString(loc)));
            }
        }
    }

    public static void set_snp_info(boolean b) {
        snp_info = b;
    }

    private String get_accession() {
        StringTokenizer st = new StringTokenizer(this.filename, "/");
        String result = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!Str.is_genbank_accession(token)) continue;
            result = token;
            break;
        }
        return result;
    }

    private void show_url(String url, String title) {
        System.err.println("FIX ME: launch URL here: " + url);
    }

    public void find_ids(String search) {
        search = search.toLowerCase();
        Hashtable<String, Integer> matches = new Hashtable<String, Integer>();
        if (search.length() > 0) {
            int start_offset = 0;
            boolean found = false;
            Integer dummy = new Integer(0);
            for (AssemblySequence as : this.config.assembly.get_sequences()) {
                String id = as.get_name();
                if (id.toLowerCase().indexOf(search) <= -1) continue;
                start_offset = as.get_asm_start();
                matches.put(id, dummy);
                found = true;
            }
            if (found) {
                this.canvas.center_on(start_offset);
            } else {
                new Message("No sequence IDs whose names match \"" + search + "\".");
            }
        }
        this.canvas.set_highlights(matches);
        this.canvas.repaint();
    }

    private void consensus_search(String search) {
        PaddedNucleotideSearch pns = new PaddedNucleotideSearch(new String(this.config.assembly.get_consensus_sequence()));
        Enumeration e = pns.find(search);
        if (e.hasMoreElements()) {
            int start = (Integer)e.nextElement();
            this.canvas.set_consensus_highlight(start, pns.get_end(start));
            this.canvas.center_on(start);
        } else {
            new Message("Sorry, not found.");
        }
    }

    public void set_postgres(boolean status) {
        this.use_postgres = status;
    }

    private void find_snps() {
        this.config.snp_config.REPORT_RESULTS = false;
        this.config.snp_config.CHECK_GENOME_VERSION = false;
        Cursor previous_cursor = this.canvas.getCursor();
        this.canvas.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Timer tm = new Timer("snp find");
            SAMStreamingSNPFinder sf = new SAMStreamingSNPFinder(this.config.snp_config);
            sf.extent_setup(this.config);
            sf.set_dbsnp(false);
            sf.find_snps();
            ArrayList<SNP2> results = sf.get_results();
            tm.finish();
            SNPList sl = new SNPList();
            PadMap pm = this.config.assembly.get_padmap();
            for (SNP2 snp2 : results) {
                SNP snp = new SNP();
                snp.filename = "n/a";
                snp.contig = snp2.reference_sequence_name;
                snp.position = pm.get_unpadded_to_padded(snp2.base_number - this.config.ruler_start);
                if (snp2.type.equals("insertion")) {
                    --snp.position;
                }
                snp.location_id = -1;
                snp.score = snp2.p_value;
                snp.snp2 = snp2;
                sl.add(snp);
            }
            if (sl == null || sl.size() == 0) {
                JOptionPane.showMessageDialog(this, "No SNPs were found.", "Message", 1);
            } else {
                Dimension initial_pref_size = this.sp_snps.getPreferredSize();
                sl.sort();
                this.config.assembly.set_snps(sl);
                this.sp_snps.setEnabled(true);
                SpinnerListModel slm = (SpinnerListModel)this.sp_snps.getModel();
                System.err.println("SNP count: " + sl.size());
                ArrayList<String> descs = new ArrayList<String>();
                int snp_num = 0;
                for (Object o : sl) {
                    SNP2 snp2 = ((SNP)o).snp2;
                    String label = new String("#" + ++snp_num + ": ");
                    label = snp2.type.equals("SNP") ? label.concat(snp2.reference_allele + ">" + snp2.alternative_allele) : label.concat(snp2.type.substring(0, 3) + " " + snp2.size);
                    descs.add(label);
                }
                slm.setList(descs);
                if (!this.sp_snps.isVisible()) {
                    this.sp_snps.setPreferredSize(initial_pref_size);
                    this.sp_snps.setVisible(true);
                    this.sp_snps.invalidate();
                }
            }
        }
        catch (Exception e) {
            new ErrorReporter(e);
        }
        this.canvas.setCursor(previous_cursor);
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.b_best_snp)) {
            SNPList snps = this.config.assembly.get_snps();
            if (this.config.assembly.has_quality()) {
                new SNPControl(Gr.getJFrame(this), this, this.config.snp_config, this.config);
            } else {
                System.err.println("can't call SNPs without quality data.");
            }
            this.snp_move(1);
        } else if (src.equals(this.b_find)) {
            this.find();
        } else if (src.equals(this.b_help)) {
            this.show_url("http://lpgws.nci.nih.gov/html-cgap/gai_assembly_help.html", "Help");
        } else if (src.equals(this.b_exit)) {
            ((AceViewer)Gr.getFrame(this)).die();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource().equals(this.choice_contigs)) {
            String new_contig = (String)this.choice_contigs.getSelectedItem();
            if (!this.config.assembly.get_contig_id().equals(new_contig)) {
                this.config.assembly.set_contig(new_contig);
                this.canvas.reset();
                if (this.all_snps != null && this.all_snps.containsKey(new_contig)) {
                    this.config.assembly.set_snps((SNPList)this.all_snps.get(new_contig));
                    this.snp_move(0);
                }
                this.canvas.repaint();
            }
        } else if (e.getSource().equals(this.choice_exons)) {
            this.set_current_refgene();
        } else {
            System.err.println("unhandled event");
        }
    }

    private void set_current_refgene() {
        RefGene rg = this.get_current_exon_refgene();
        if (rg != null) {
            ArrayList<Exon> exons = rg.get_exons();
            ArrayList<Integer> usable_exons = new ArrayList<Integer>();
            for (Exon exon : exons) {
                if (exon.get_first_start() <= 0) continue;
                int exno = Integer.parseInt(exon.id);
                usable_exons.add(exno);
            }
            if (usable_exons.size() > 0) {
                SpinnerListModel slm = (SpinnerListModel)this.sp_exons.getModel();
                slm.setList(usable_exons);
                slm.setValue(usable_exons.get(0));
            }
        }
    }

    public void keyPressed(KeyEvent ke) {
        int code = ke.getKeyCode();
        if (code == 88) {
            this.config.assembly.set_snps(null);
            this.canvas.repaint();
        } else if (code == 81) {
            System.exit(0);
        }
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
    }

    public void mouseExited(MouseEvent e) {
    }

    public void init_exon_navigation() {
        this.choice_exons.removeAllItems();
        if (this.config.refgenes == null) {
            return;
        }
        for (RefGene rg : this.config.refgenes) {
            if (rg.is_broken()) {
                System.err.println("skipping broken refgene " + rg.get_accession());
                continue;
            }
            this.choice_exons.addItem(rg.get_accession());
        }
        this.set_current_refgene();
        this.sp_exons.invalidate();
        this.choice_exons.invalidate();
        this.cp.validate();
        this.choice_exons.setEnabled(true);
        this.sp_exons.setEnabled(true);
        this.sp_exons.addChangeListener(this);
        this.choice_exons.addItemListener(this);
    }

    public void stateChanged(ChangeEvent e) {
        RefGene rg;
        Object src = e.getSource();
        if (src.equals(this.sp_exons) && (rg = this.get_current_exon_refgene()) != null) {
            int exno = (Integer)this.sp_exons.getValue();
            Exon exon = rg.get_exon_id(Integer.toString(exno));
            ArrayList<Codon> codons = exon.get_codons();
            if (codons.size() == 0) {
                System.err.println("no codon mapping for exon " + exno);
            } else {
                for (Codon c : codons) {
                    if (c.is_unmappable()) continue;
                    int pos = codons.get(0).c_last_offset();
                    this.canvas.center_on(pos);
                    break;
                }
            }
        }
    }

    private RefGene get_current_exon_refgene() {
        String accession = (String)this.choice_exons.getSelectedItem();
        RefGene result = null;
        if (this.config.refgenes != null) {
            for (RefGene rg : this.config.refgenes) {
                if (!rg.get_accession().equals(accession)) continue;
                result = rg;
                break;
            }
        }
        return result;
    }

    public AssemblyCanvas get_canvas() {
        return this.canvas;
    }

    public boolean is_built() {
        return this.is_built;
    }

    public Assembly get_assembly() {
        return this.config.assembly;
    }

    public void post_load() {
        if (this.is_built) {
            System.err.println("UI already built");
        } else if (this.choice_contigs == null || this.canvas == null) {
            System.err.println("UI not ready yet");
        } else {
            this.canvas.requestFocus();
            if (this.config.assembly.supports_contigs()) {
                for (String item : this.config.assembly.get_contig_id_list()) {
                    if (item.equals("Contig1")) continue;
                    this.choice_contigs.addItem(item);
                }
                this.choice_contigs.setSelectedItem(this.start_contig);
            }
            if (this.start_snps != null) {
                System.err.println("setting start SNPs");
                this.config.assembly.set_snps(this.start_snps);
                this.sp_snps.setEnabled(true);
            }
            this.config.assembly.build_alignment();
            if (this.config.refgenes != null) {
                PadMap pm = this.config.assembly.get_padmap();
                for (RefGene rg : this.config.refgenes) {
                    rg.consensus_setup(pm);
                }
                this.init_exon_navigation();
            } else if (this.config.ENABLE_JDBC && this.config.region != null && this.config.region.isValid()) {
                AnnotationLoader al = new AnnotationLoader(this.config, true);
                al.addObserver(this);
            }
            this.init_hetero_summary();
            this.canvas.repaint();
            if (this.config.start_padded_offset != 0 || this.config.start_unpadded_offset != 0) {
                int clen = this.config.assembly.get_consensus_sequence().length;
                if (this.config.start_unpadded_offset < clen) {
                    int cpos = this.config.start_padded_offset != 0 ? this.config.start_padded_offset : this.config.assembly.get_padmap().get_unpadded_to_padded(this.config.start_unpadded_offset);
                    SNPList sl = new SNPList();
                    sl.addElement(new SNP(cpos, 0.0));
                    this.config.assembly.set_snps(sl);
                    this.canvas.center_on(this.config.start_padded_offset);
                }
            } else if (this.start_offset != -1) {
                this.canvas.center_on(this.start_offset);
            } else if (this.start_snps != null) {
                this.snp_move(0);
            }
            this.is_built = true;
        }
    }

    public void switch_assembly(String text) {
        String[] things;
        SAMRegion region = new SAMRegion();
        this.setCursor(new Cursor(3));
        this.repaint();
        String DELIMITER = ":";
        try {
            String[] stuff = text.split(DELIMITER);
            String rn = stuff[0];
            for (SAMResource sr : this.config.sams) {
                ChromosomeDisambiguator cd = new ChromosomeDisambiguator(sr.getSamReader());
                region.tname = cd.find(rn);
                if (region.tname == null) continue;
                break;
            }
        }
        catch (Exception e) {
            System.err.println("ERROR getting SamReaders");
        }
        if (region.tname == null) {
            JDBCCache ucsc = this.config.get_ucsc_genome_client();
            ArrayList<HashMap<String, String>> results = null;
            try {
                results = ucsc.query("select * from refGene where name2=\"" + text + "\"");
            }
            catch (Exception e) {
                System.err.println("ERROR: " + e);
                e.printStackTrace();
            }
            if (results != null && results.size() > 0) {
                GeneInfo gi = new GeneInfo();
                gi.import_ucsc(results);
                region.tname = gi.chr.toString();
                region.range.start = gi.start;
                region.range.end = gi.end;
                region.gene_name = text;
            }
        }
        if (region.gene_name == null && (things = (text = Str.trim_whitespace(text)).split(DELIMITER)).length >= 1 && things.length <= 2) {
            if (things.length == 1) {
                this.config.region = region;
                try {
                    this.config.region_default_setup();
                }
                catch (Exception e) {
                    System.err.println("ERROR setting startup range for ref seq");
                    System.err.println("setting range to ref start");
                    region.range.start = 1;
                    region.range.end = this.config.DEFAULT_INITIAL_VIEW_NT;
                }
                System.err.println("result=" + region.range.start);
            } else {
                String[] pos = things[1].split("-");
                try {
                    if (pos.length == 1) {
                        int center = Integer.parseInt(pos[0]);
                        int flank = this.config.DEFAULT_INITIAL_VIEW_NT / 2;
                        int start = center - flank;
                        int end = center + flank;
                        if (start < 1) {
                            start = 1;
                        }
                        region.range.start = start;
                        region.range.end = end;
                    } else if (pos.length == 2) {
                        region.range.start = Integer.parseInt(pos[0]);
                        region.range.end = Integer.parseInt(pos[1]);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        try {
            if (region.isValid()) {
                this.repaint();
                this.config.region = region;
                SAMUtils.sam_config_setup(this.config, region);
                SpinnerListModel slm = (SpinnerListModel)this.sp_snps.getModel();
                ArrayList<String> dummy = new ArrayList<String>();
                String dvalue = "                         ";
                dummy.add(dvalue);
                slm.setList(dummy);
                this.sp_snps.setValue(dvalue);
                this.config.assembly = new SAMAssembly(this.config, true);
                this.canvas.set_config(this.config);
                JFrame jf = Gr.getJFrame(this);
                Runnable later = new Runnable(){

                    public void run() {
                        while (true) {
                            if (((AcePanel)AcePanel.this).config.assembly.alignment_is_built()) {
                                AcePanel.this.setCursor(new Cursor(0));
                                AnnotationLoader al = new AnnotationLoader(AcePanel.this.config, true);
                                al.addObserver(AcePanel.this.deep_sigh);
                                AcePanel.this.init_hetero_summary();
                                break;
                            }
                            if (((AcePanel)AcePanel.this).config.assembly.has_error()) {
                                AcePanel.this.setCursor(new Cursor(0));
                                AcePanel.this.repaint();
                                break;
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                };
                new Thread(later).start();
                if (jf != null) {
                    jf.setTitle(this.config.title);
                    jf.repaint();
                }
                this.canvas.repaint();
            } else {
                JOptionPane.showMessageDialog(this, "Specify a gene symbol or a location in the format chrX, chrX:start, or chrX:start-end", "Error", 0);
                this.setCursor(new Cursor(0));
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    public void init_hetero_summary() {
        this.config.hetero_summary = new HeteroSummary(this.config, true);
        this.canvas.set_hetero_summary(this.config.hetero_summary);
    }
}

