/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Ace;
import Ace2.AceSequence;
import Ace2.AceViewerConfig;
import Ace2.AlignmentSequence;
import Ace2.Assembly;
import Ace2.AssemblySequence;
import Ace2.FASTAQualityReader;
import Ace2.Sample;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Observer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Alignment
extends Assembly {
    public Ace ace;
    HashMap<String, AlignmentSequence> alignment = new HashMap();
    Vector forward_ids;
    Vector reverse_ids;
    Vector forward_ids_alpha;
    Vector reverse_ids_alpha;
    Vector forward_ids_grouped;
    Vector reverse_ids_grouped;
    Vector forward_ids_grouped_alpha;
    Vector reverse_ids_grouped_alpha;
    boolean built;
    private ArrayList<AssemblySequence> all_visible;
    private int last_cs;
    private int last_ce;
    private boolean last_bypos;
    private HashMap<String, ArrayList<Integer>> quals = null;
    private FASTAQualityReader fq;
    private AceViewerConfig config = new AceViewerConfig();

    public Alignment(Ace a, AceViewerConfig config) {
        this.config = config;
        this.ace = a;
    }

    public Alignment(Ace a) {
        this.ace = a;
    }

    @Override
    public void set_contig(String contig_id) {
        this.built = false;
        this.ace.set_current_contig(contig_id);
        this.build_alignment();
    }

    @Override
    public void build_alignment() {
        super.build_alignment();
        this.built = false;
        this.alignment.clear();
        AceSequence cseq = this.ace.consensus();
        this.alignment.put(cseq.name, new AlignmentSequence(cseq));
        String[] ids = this.ace.member_id_list;
        for (int i = 0; i < ids.length; ++i) {
            this.build(this.ace.get_member(ids[i]));
        }
        this.build_summary_info();
        this.built = true;
    }

    private void build(AceSequence am) {
        ArrayList<Integer> q;
        AlignmentSequence as = new AlignmentSequence(am);
        if (this.quals != null && (q = this.quals.get(am.name)) != null) {
            as.map_quality(q);
        }
        this.alignment.put(am.name, as);
    }

    @Override
    public void build_summary_info() {
        this.forward_ids = new Vector();
        this.reverse_ids = new Vector();
        boolean group_mode = this.config.read2sample != null;
        Vector<String> group_n_f = new Vector<String>();
        Vector<String> group_n_r = new Vector<String>();
        Vector<String> group_t_f = new Vector<String>();
        Vector<String> group_t_r = new Vector<String>();
        for (int i = 0; i < this.ace.member_id_list.length; ++i) {
            String id = this.ace.member_id_list[i];
            AceSequence s = this.ace.get_member(id);
            if (s.complemented) {
                this.reverse_ids.addElement(id);
            } else {
                this.forward_ids.addElement(id);
            }
            if (!group_mode) continue;
            Sample sa = this.config.read2sample.get(id);
            if (sa == null || !sa.is_normal() && !sa.is_tumor()) {
                System.err.println("error: can't determine tumor/normal for " + id);
                if (s.complemented) {
                    group_n_r.addElement(id);
                    continue;
                }
                group_n_f.addElement(id);
                continue;
            }
            if (sa.is_normal()) {
                if (s.complemented) {
                    group_n_r.addElement(id);
                    continue;
                }
                group_n_f.addElement(id);
                continue;
            }
            if (sa == null || !sa.is_tumor()) continue;
            if (s.complemented) {
                group_t_r.addElement(id);
                continue;
            }
            group_t_f.addElement(id);
        }
        this.forward_ids_alpha = new Vector(this.forward_ids);
        this.reverse_ids_alpha = new Vector(this.reverse_ids);
        Collections.sort(this.forward_ids_alpha);
        Collections.sort(this.reverse_ids_alpha);
        if (group_mode) {
            this.forward_ids_grouped = new Vector(group_n_f);
            this.forward_ids_grouped.addAll(group_t_f);
            this.reverse_ids_grouped = new Vector(group_n_r);
            this.reverse_ids_grouped.addAll(group_t_r);
            this.forward_ids_grouped_alpha = new Vector(this.forward_ids_grouped);
            this.reverse_ids_grouped_alpha = new Vector(this.reverse_ids_grouped);
            Collections.sort(this.forward_ids_grouped_alpha);
            Collections.sort(this.reverse_ids_grouped_alpha);
        }
    }

    @Override
    public AlignmentSequence get_sequence(String id) {
        return this.alignment.get(id);
    }

    @Override
    public ArrayList<AssemblySequence> get_sequences() {
        return new ArrayList<AssemblySequence>(this.alignment.values());
    }

    @Override
    public char[] get_consensus_sequence() {
        return this.ace.consensus().sequence.toCharArray();
    }

    @Override
    public boolean alignment_is_built() {
        return this.built;
    }

    AlignmentSequence get_consensus() {
        return this.alignment.get(this.ace.consensus().name);
    }

    @Override
    public ArrayList<AssemblySequence> get_visible_sequences(int contig_start_view, int contig_end_view) {
        if (contig_start_view != this.last_cs || contig_end_view != this.last_ce || this.display_sequences_by_position != this.last_bypos) {
            Vector r_set;
            Vector f_set;
            boolean group_mode;
            this.all_visible = new ArrayList();
            boolean bl = group_mode = this.config.read2sample != null;
            if (group_mode && this.forward_ids_grouped != null) {
                f_set = this.display_sequences_by_position ? this.forward_ids_grouped : this.forward_ids_grouped_alpha;
                r_set = this.display_sequences_by_position ? this.reverse_ids_grouped : this.reverse_ids_grouped_alpha;
            } else {
                f_set = this.display_sequences_by_position ? this.forward_ids : this.forward_ids_alpha;
                r_set = this.display_sequences_by_position ? this.reverse_ids : this.reverse_ids_alpha;
            }
            this.populate_visible(this.all_visible, f_set, contig_start_view, contig_end_view);
            this.populate_visible(this.all_visible, r_set, contig_start_view, contig_end_view);
            this.last_cs = contig_start_view;
            this.last_ce = contig_end_view;
            this.last_bypos = this.display_sequences_by_position;
        }
        return this.all_visible;
    }

    private void populate_visible(ArrayList<AssemblySequence> v, Vector src, int contig_start_view, int contig_end_view) {
        Enumeration e = src.elements();
        while (e.hasMoreElements()) {
            String id = (String)e.nextElement();
            AlignmentSequence as = this.get_sequence(id);
            if (as.get_asm_start() >= contig_end_view || as.get_asm_end() <= contig_start_view) continue;
            v.add(as);
        }
    }

    @Override
    public void set_quality(FASTAQualityReader fq) {
        this.fq = fq;
        HashMap<String, ArrayList<Integer>> quals = fq.get_quality();
        this.quals = quals;
        for (String id : this.alignment.keySet()) {
            AlignmentSequence as = this.alignment.get(id);
            ArrayList<Integer> q = quals.get(id);
            if (q == null) continue;
            as.map_quality(q);
        }
    }

    @Override
    public boolean has_quality() {
        return this.quals != null;
    }

    @Override
    public String get_biggest_contig_id() {
        return this.ace.get_biggest_contig();
    }

    @Override
    public String get_contig_id() {
        return this.ace.get_contig_id();
    }

    @Override
    public ArrayList<String> get_contig_id_list() {
        return new ArrayList<String>(this.ace.contigs.keySet());
    }

    @Override
    public boolean supports_contigs() {
        return true;
    }

    @Override
    public boolean has_error() {
        return this.ace.error();
    }

    @Override
    public String get_error_message() {
        return "fix me!";
    }

    @Override
    public boolean is_empty() {
        return this.ace.is_empty();
    }

    @Override
    public Sample get_sample_for(String id) {
        return this.config.read2sample == null ? null : this.config.read2sample.get(id);
    }

    @Override
    public boolean is_loaded() {
        return this.ace.loaded();
    }

    @Override
    public String get_title() {
        return this.ace.filename;
    }

    @Override
    public void addObserver(Observer o) {
        System.err.println("addObserver not implemented");
    }
}

