/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AceSequence;
import Ace2.AssemblySequence;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignmentSequence
implements AssemblySequence {
    private int[] quality = null;
    private int cs;
    private int ce;
    public AceSequence ace_seq;

    AlignmentSequence(AceSequence ace_seq) {
        this.ace_seq = ace_seq;
        this.cs = ace_seq.asm_start_padded + ace_seq.clip_start_padded - 1;
        this.ce = ace_seq.asm_start_padded + ace_seq.clip_end_padded - 1;
    }

    public String get_id() {
        return this.ace_seq.name;
    }

    @Override
    public char get_base(int consensus_pos) {
        return this.ace_seq.get_base(consensus_pos);
    }

    @Override
    public int get_quality(int consensus_pos) {
        int i = this.ace_seq.consensus_to_index(consensus_pos);
        if (this.quality != null && i > -1) {
            return this.quality[i];
        }
        return -1;
    }

    public boolean complemented() {
        return this.ace_seq.complemented;
    }

    boolean sanity_check(char base1, char base2, int asm_pos, String type) {
        boolean broken = true;
        if (base1 == base2 || base1 == 'x' || base1 == 'X' || base2 == 'x' || base2 == 'X') {
            broken = false;
        } else {
            switch (base1) {
                case 'A': 
                case 'a': {
                    if (base2 != 'a' && base2 != 'A') break;
                    broken = false;
                    break;
                }
                case 'C': 
                case 'c': {
                    if (base2 != 'c' && base2 != 'C') break;
                    broken = false;
                    break;
                }
                case 'G': 
                case 'g': {
                    if (base2 != 'g' && base2 != 'G') break;
                    broken = false;
                    break;
                }
                case 'T': 
                case 't': {
                    if (base2 != 't' && base2 != 'T') break;
                    broken = false;
                }
            }
        }
        if (broken) {
            System.out.println(type + " data for " + this.ace_seq.name + " is out of sync at " + asm_pos + ". base1:" + base1 + " base2:" + base2);
        }
        return broken;
    }

    public boolean is_visible(int offset, boolean hq) {
        if (hq) {
            return offset >= this.cs && offset <= this.ce;
        }
        return offset >= this.ace_seq.asm_start_padded && offset <= this.ace_seq.asm_end_padded;
    }

    public void map_quality(ArrayList<Integer> quals_raw) {
        ArrayList<Integer> quals = quals_raw;
        if (this.complemented()) {
            quals = new ArrayList<Integer>(quals_raw);
            Collections.reverse(quals);
        }
        String aceseq = this.ace_seq.sequence.toString();
        int acelen = aceseq.length();
        this.quality = new int[acelen];
        int qs = quals.size();
        int i_asm = 0;
        int i_qual = 0;
        while (i_qual < qs) {
            while (aceseq.charAt(i_asm) == '*') {
                this.quality[i_asm++] = -1;
            }
            this.quality[i_asm] = quals.get(i_qual++);
            ++i_asm;
        }
    }

    @Override
    public String get_name() {
        return this.ace_seq.name;
    }

    @Override
    public int get_asm_start() {
        return this.ace_seq.asm_start_padded;
    }

    @Override
    public int get_asm_end() {
        return this.ace_seq.asm_end_padded;
    }

    @Override
    public int get_clip_start() {
        return this.cs;
    }

    @Override
    public int get_clip_end() {
        return this.ce;
    }

    @Override
    public boolean is_complemented() {
        return this.ace_seq.complemented;
    }

    @Override
    public void get_visible_sequence(char[] buf, int cpos) {
        this.ace_seq.get_visible_sequence(buf, cpos);
    }

    @Override
    public SAMRecord get_samrecord() {
        return null;
    }

    @Override
    public int get_padded_index(int cpos) {
        return cpos - this.get_asm_start();
    }
}

