/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AssemblySequence;
import Ace2.FASTAQualityReader;
import Ace2.IntBucketIndex;
import Ace2.PadMap;
import Ace2.SNPList;
import Ace2.Sample;
import java.util.ArrayList;
import java.util.Observer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Assembly {
    protected IntBucketIndex seqs_by_asp;
    protected int leftmost;
    protected int rightmost;
    protected int longest_id;
    protected boolean display_sequences_by_position = true;
    protected SNPList snps;
    protected PadMap pm;

    public void build_alignment() {
        boolean first = true;
        this.seqs_by_asp = new IntBucketIndex(100);
        for (AssemblySequence as : this.get_sequences()) {
            int nlen = as.get_name().length();
            int start = as.get_asm_start();
            int end = as.get_asm_end();
            this.seqs_by_asp.add_range(start, end, as);
            if (first) {
                this.leftmost = start;
                this.rightmost = end;
                this.longest_id = nlen;
                first = false;
                continue;
            }
            if (start < this.leftmost) {
                this.leftmost = start;
            }
            if (end > this.rightmost) {
                this.rightmost = end;
            }
            if (nlen <= this.longest_id) continue;
            this.longest_id = nlen;
        }
    }

    public ArrayList<AssemblySequence> get_aligned_at(int offset) {
        ArrayList<AssemblySequence> results = new ArrayList<AssemblySequence>();
        for (Object o : this.seqs_by_asp.find(offset)) {
            AssemblySequence as = (AssemblySequence)o;
            if (offset > as.get_asm_end()) continue;
            results.add(as);
        }
        return results;
    }

    public ArrayList<AssemblySequence> get_visible_sequences(int contig_start_view, int contig_end_view) {
        ArrayList<AssemblySequence> fwd = new ArrayList<AssemblySequence>();
        ArrayList<AssemblySequence> rev = new ArrayList<AssemblySequence>();
        for (AssemblySequence o : this.get_sequences()) {
            AssemblySequence as = o;
            if (as.get_asm_start() >= contig_end_view || as.get_asm_end() < contig_start_view) continue;
            if (as.is_complemented()) {
                rev.add(as);
                continue;
            }
            fwd.add(as);
        }
        fwd.addAll(rev);
        return fwd;
    }

    public PadMap get_padmap() {
        if (this.is_loaded() && this.pm == null) {
            this.pm = new PadMap(this.get_consensus_sequence());
        }
        return this.pm;
    }

    public int get_leftmost() {
        return this.leftmost;
    }

    public int get_rightmost() {
        return this.rightmost;
    }

    public int get_assembly_width() {
        return this.get_rightmost() - this.get_leftmost() + 1;
    }

    public SNPList get_snps() {
        return this.snps;
    }

    public void set_snps(SNPList snps) {
        this.snps = snps;
    }

    public void set_display_by_position(boolean v) {
        this.display_sequences_by_position = v;
    }

    public int get_max_id_length() {
        return this.longest_id;
    }

    public abstract void build_summary_info();

    public abstract void addObserver(Observer var1);

    public abstract String get_title();

    public abstract boolean is_loaded();

    public abstract boolean is_empty();

    public abstract boolean has_error();

    public abstract String get_error_message();

    public abstract boolean alignment_is_built();

    public abstract char[] get_consensus_sequence();

    public abstract ArrayList<AssemblySequence> get_sequences();

    public abstract AssemblySequence get_sequence(String var1);

    public abstract Sample get_sample_for(String var1);

    public abstract void set_quality(FASTAQualityReader var1);

    public abstract boolean has_quality();

    public abstract boolean supports_contigs();

    public abstract ArrayList<String> get_contig_id_list();

    public abstract String get_contig_id();

    public abstract void set_contig(String var1);

    public abstract String get_biggest_contig_id();
}

