/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.WorkingDirectory;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BAMConcat {
    public static void concatenate_bams(ArrayList<File> in_files, File out_file) {
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(in_files.get(0));
        SAMFileHeader header_in = reader.getFileHeader();
        SAMFileWriter sfw = new SAMFileWriterFactory().makeBAMWriter(header_in, false, out_file, 1);
        for (File bam : in_files) {
            System.err.println("processing " + bam);
            reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(bam);
            for (SAMRecord sr : reader) {
                sfw.addAlignment(sr);
            }
        }
        sfw.close();
    }

    public static void main(String[] argv) {
        ArrayList<File> in_files = new ArrayList<File>();
        File out_file = null;
        boolean use_tmpdir = false;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-in")) {
                in_files.add(new File(argv[++i]));
                continue;
            }
            if (argv[i].equals("-out")) {
                out_file = new File(argv[++i]);
                continue;
            }
            if (!argv[i].equals("-tmpdir")) continue;
            use_tmpdir = true;
        }
        if (in_files.size() > 0 && out_file != null) {
            try {
                WorkingDirectory wd = null;
                if (use_tmpdir) {
                    String temp_dir = System.getenv("TMPDIR");
                    if (temp_dir == null) {
                        System.err.println("ERROR: no TMPDIR environment variable; use -temp-dir X to specify manually");
                        System.exit(1);
                    } else {
                        File f = out_file.getCanonicalFile();
                        File parent = f.getParentFile();
                        File target_dir = parent == null ? new File(".") : parent;
                        wd = new WorkingDirectory(new File(temp_dir), target_dir);
                        System.err.println("raw outfile=" + out_file);
                        out_file = wd.get_file(f.getName());
                        System.err.println("working directory outfile=" + out_file);
                    }
                }
                BAMConcat.concatenate_bams(in_files, out_file);
                if (wd != null) {
                    wd.finish();
                }
            }
            catch (Exception e) {
                System.err.println("ERROR: " + e);
            }
        } else {
            System.err.println("ERROR specify -in [bam] [-in [bam]...] + -out [bam]");
        }
    }
}

