/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.ChromosomeDisambiguator;
import Ace2.ReferenceSequence;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import java.io.IOException;
import java.util.ArrayList;

public class BAMReferenceCompatibility {
    private SAMFileHeader sfh;
    private ReferenceSequence rs;
    boolean HAS_MISSING_SEQUENCES;
    boolean HAS_LENGTH_MISMATCHES;
    private ArrayList<String> errors;

    public BAMReferenceCompatibility(SAMFileHeader sfh, ReferenceSequence rs) throws IOException {
        this.sfh = sfh;
        this.rs = rs;
        this.HAS_LENGTH_MISMATCHES = false;
        this.HAS_MISSING_SEQUENCES = false;
        this.setup();
    }

    private void setup() throws IOException {
        this.errors = new ArrayList();
        if (this.rs.supports_sequence_list()) {
            ArrayList<String> ref_names = this.rs.get_sequence_names();
            ChromosomeDisambiguator cd = new ChromosomeDisambiguator(ref_names);
            SAMSequenceDictionary ssd = this.sfh.getSequenceDictionary();
            for (SAMSequenceRecord ssr : ssd.getSequences()) {
                String ref_name_bam = ssr.getSequenceName();
                String ref_name_ref = cd.find(ref_name_bam);
                if (ref_name_ref == null) {
                    this.HAS_MISSING_SEQUENCES = true;
                    this.errors.add("no reference sequence for " + ref_name_bam);
                    continue;
                }
                int ref_length_ref = this.rs.get_length(ref_name_ref);
                if (ssr.getSequenceLength() == ref_length_ref) continue;
                this.HAS_LENGTH_MISMATCHES = true;
                this.errors.add("reference length mismatch for " + ref_name_bam + " bam=" + ssr.getSequenceLength() + " reference:" + ref_length_ref);
            }
        } else {
            throw new IOException("reference sequence doesn't support sequence list");
        }
    }

    public boolean has_any_incompatibility() {
        return this.HAS_MISSING_SEQUENCES || this.HAS_LENGTH_MISMATCHES;
    }

    public void report_errors() {
        for (String msg : this.errors) {
            System.err.println("ERROR: " + msg);
        }
    }
}

