/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Base;
import Ace2.HashCounter;
import Funk.Str;
import java.util.ArrayList;

public class BaseCountSummary {
    int count_a;
    int count_c;
    int count_g;
    int count_t;
    int count_other;
    int count_reference;
    int count_total;
    int count_variant;
    Base reference_base = null;
    int count_CCG_CAG;
    int count_CGG_CTG;
    static final String[] all_spectrum_tags = new String[]{"A>C", "A>G", "A>T", "C>A", "C>G", "C>T", "G>A", "G>C", "G>T", "T>A", "T>C", "T>G", "CCG>CAG", "CGG>CTG"};

    public BaseCountSummary() {
        this.reset();
    }

    public void reset() {
        this.count_variant = 0;
        this.count_total = 0;
        this.count_reference = 0;
        this.count_other = 0;
        this.count_t = 0;
        this.count_g = 0;
        this.count_c = 0;
        this.count_a = 0;
        this.count_CGG_CTG = 0;
        this.count_CCG_CAG = 0;
    }

    public void add_base(Base b, boolean is_reference) {
        ++this.count_total;
        if (is_reference) {
            ++this.count_reference;
            this.reference_base = b;
        } else {
            ++this.count_variant;
        }
        switch (b) {
            case BASE_A: {
                ++this.count_a;
                break;
            }
            case BASE_C: {
                ++this.count_c;
                break;
            }
            case BASE_G: {
                ++this.count_g;
                break;
            }
            case BASE_T: {
                ++this.count_t;
                break;
            }
            default: {
                ++this.count_other;
            }
        }
    }

    public float get_dominant_allele_frequency() {
        int max = 0;
        if (this.count_a > max) {
            max = this.count_a;
        }
        if (this.count_c > max) {
            max = this.count_c;
        }
        if (this.count_g > max) {
            max = this.count_g;
        }
        if (this.count_t > max) {
            max = this.count_t;
        }
        float result = 1.0f;
        if (this.count_total > 0) {
            result = (float)max / (float)this.count_total;
        }
        return result;
    }

    public int get_count_total() {
        return this.count_total;
    }

    public int get_count_reference() {
        return this.count_reference;
    }

    public int get_count_variant() {
        return this.count_variant;
    }

    public void get_background_spectra(HashCounter counts, boolean verbose) throws Exception {
        if (this.reference_base == null) {
            throw new Exception("no reference base defined");
        }
        Base[] all = new Base[]{Base.BASE_A, Base.BASE_C, Base.BASE_G, Base.BASE_T};
        for (int i = 0; i < 4; ++i) {
            if (this.reference_base.equals((Object)all[i])) continue;
            int other_count = 0;
            switch (all[i]) {
                case BASE_A: {
                    other_count = this.count_a;
                    break;
                }
                case BASE_C: {
                    other_count = this.count_c;
                    break;
                }
                case BASE_G: {
                    other_count = this.count_g;
                    break;
                }
                case BASE_T: {
                    other_count = this.count_t;
                }
            }
            if (other_count <= 0) continue;
            String tag = (Object)((Object)this.reference_base) + ">" + (Object)((Object)all[i]);
            if (verbose) {
                System.err.println("  " + (Object)((Object)this.reference_base) + ">" + (Object)((Object)all[i]) + " = " + other_count);
            }
            counts.add(tag, other_count);
        }
        if (this.count_CCG_CAG > 0) {
            counts.add("CCG>CAG", this.count_CCG_CAG);
        }
        if (this.count_CGG_CTG > 0) {
            counts.add("CGG>CTG", this.count_CGG_CTG);
        }
    }

    public boolean is_variant_allele_dominant() {
        float f = (float)this.count_variant / (float)this.count_reference;
        return f >= 0.5f;
    }

    public static String summarize_background_spectrum(HashCounter counts) {
        ArrayList<String> things = new ArrayList<String>();
        for (int i = 0; i < all_spectrum_tags.length; ++i) {
            things.add(all_spectrum_tags[i] + "=" + counts.get_count(all_spectrum_tags[i]));
        }
        return Str.join(",", things);
    }

    public void add_CCG_CAG() {
        ++this.count_CCG_CAG;
    }

    public void add_CGG_CTG() {
        ++this.count_CGG_CTG;
    }
}

