/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Assembly;
import Ace2.AssemblySequence;
import Ace2.Base;
import Ace2.BaseCountInfo;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BaseCounter3 {
    public static boolean ALLOW_GAP_SNPS = false;
    public static boolean ALLOW_UNKNOWN_BASES = false;
    public static boolean INCLUDE_ZERO_COUNTS = true;
    private Assembly assembly;
    private int min_quality = 0;
    private EnumMap<Base, BaseCountInfo> saw_bases = new EnumMap(Base.class);

    public BaseCounter3() {
    }

    public BaseCounter3(Assembly assembly) {
        this.assembly = assembly;
    }

    public void add_base(char base) {
        this.add_base(Base.valueOf(base), null, false);
    }

    public void add_base(Base base) {
        this.add_base(base, null, false);
    }

    public void add_base(Base key, Object sequence, boolean include_count) {
        BaseCountInfo bci = this.saw_bases.get((Object)key);
        if (bci == null) {
            bci = new BaseCountInfo(key);
            this.saw_bases.put(key, bci);
        }
        if (include_count) {
            ++bci.count;
        }
        if (sequence != null) {
            bci.sequences.add(sequence);
        }
        if (!ALLOW_GAP_SNPS) {
            this.saw_bases.remove((Object)Base.BASE_GAP);
        }
        if (!ALLOW_UNKNOWN_BASES) {
            this.saw_bases.remove((Object)Base.BASE_UNKNOWN);
        }
    }

    public void set_min_quality(int q) {
        this.min_quality = q;
    }

    public void add_sequences(int cpos) {
        for (AssemblySequence as : this.assembly.get_aligned_at(cpos)) {
            SAMRecord sr;
            int q = as.get_quality(cpos);
            if (q < this.min_quality || (sr = as.get_samrecord()) != null && sr.getDuplicateReadFlag()) continue;
            this.add_base(Base.valueOf(as.get_base(cpos)), null, true);
        }
    }

    public EnumMap<Base, BaseCountInfo> get_saw_bases() {
        return this.saw_bases;
    }

    public BaseCountInfo get_info(Base base) {
        return this.saw_bases.get((Object)base);
    }

    public BaseCountInfo get_info(char base) {
        return this.saw_bases.get((Object)Base.valueOf(base));
    }

    public int count_bases() {
        return this.saw_bases.size();
    }

    public int count_sequences() {
        int total = 0;
        for (BaseCountInfo bci : this.saw_bases.values()) {
            total += bci.count;
        }
        return total;
    }

    public int count_sequences_for(char base) {
        BaseCountInfo bci = this.saw_bases.get((Object)Base.valueOf(base));
        return bci == null ? 0 : bci.count;
    }

    public Base[] get_bases_by_frequency() {
        HashSet<Integer> sizes = new HashSet<Integer>();
        int valid = 0;
        for (BaseCountInfo bci : this.saw_bases.values()) {
            if (!INCLUDE_ZERO_COUNTS && bci.count <= 0) continue;
            sizes.add(bci.count);
            ++valid;
        }
        ArrayList s2 = new ArrayList(sizes);
        Collections.sort(s2);
        Collections.reverse(s2);
        Base[] results = new Base[valid];
        int ri = 0;
        Iterator i$ = s2.iterator();
        while (i$.hasNext()) {
            int sz = (Integer)i$.next();
            for (Base b : this.saw_bases.keySet()) {
                if (this.saw_bases.get((Object)((Object)b)).count != sz) continue;
                results[ri++] = b;
            }
        }
        return results;
    }

    public HashSet<Character> get_bases() {
        HashSet<Character> results = new HashSet<Character>();
        for (Base b : this.saw_bases.keySet()) {
            if (!INCLUDE_ZERO_COUNTS && this.saw_bases.get((Object)((Object)b)).count <= 0) continue;
            results.add(Character.valueOf(b.charValue()));
        }
        return results;
    }

    public static void main(String[] argv) {
        Base x = Base.valueOf('a');
        System.err.println((Object)x);
    }
}

