/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.IntronCompressor;
import Ace2.PadMap;
import Ace2.ProteinTool;

public class Codon
implements Cloneable {
    protected char[] bases;
    protected int[] consensus_pos;
    protected int[] unpadded_pos;
    private int load_index;
    private int id;
    private int valid_bases;
    private static ProteinTool protein = new ProteinTool();
    private boolean is_rc;
    private boolean is_unmappable;

    public Codon(int id) {
        this.is_rc = false;
        this.setup(id);
    }

    public Codon(int id, boolean is_rc) {
        this.setup(id);
        this.is_rc = is_rc;
        if (is_rc) {
            this.load_index = 2;
        }
    }

    private void setup(int id) {
        this.is_rc = false;
        this.id = id;
        this.bases = new char[3];
        this.bases[2] = 33;
        this.bases[1] = 33;
        this.bases[0] = 33;
        this.valid_bases = 0;
        this.consensus_pos = new int[3];
        this.unpadded_pos = new int[3];
        this.load_index = 0;
        this.is_unmappable = false;
    }

    public void set_unmappable(boolean v) {
        this.is_unmappable = v;
    }

    public boolean is_unmappable() {
        return this.is_unmappable;
    }

    public void increment_valid_bases() {
        ++this.valid_bases;
    }

    public int get_valid_base_count() {
        return this.valid_bases;
    }

    public void append(char c, int upos, int cpos) {
        if (this.is_rc ? this.load_index >= 0 : this.load_index < 3) {
            this.bases[this.load_index] = Character.toUpperCase(c);
            if (this.is_rc) {
                this.bases[this.load_index] = this.complement(this.bases[this.load_index]);
            }
            this.unpadded_pos[this.load_index] = upos;
            this.consensus_pos[this.load_index] = cpos;
            this.load_index += this.is_rc ? -1 : 1;
        }
    }

    public boolean complete() {
        return this.is_rc ? this.load_index < 0 : this.load_index > 2;
    }

    public String toString() {
        return new String(this.bases);
    }

    public int c_start_offset() {
        return this.consensus_pos[0];
    }

    public int c_center_offset() {
        return this.consensus_pos[1];
    }

    public int c_last_offset() {
        return this.consensus_pos[2];
    }

    public int u_start_offset() {
        return this.unpadded_pos[0];
    }

    public int u_center_offset() {
        return this.unpadded_pos[1];
    }

    public int u_last_offset() {
        return this.unpadded_pos[2];
    }

    public char to_code() {
        return protein.dna_to_code(this.toString());
    }

    public String to_name() {
        return protein.code_to_name(protein.dna_to_code(this.toString()));
    }

    public boolean is_stop() {
        return this.to_code() == '!';
    }

    public boolean is_silent(Codon other) {
        return this.to_code() == other.to_code();
    }

    public int get_consensus_for(int unpadded) {
        for (int i = 0; i < 3; ++i) {
            if (this.unpadded_pos[i] != unpadded) continue;
            return this.consensus_pos[i];
        }
        return 0;
    }

    public boolean intersects_padded_consensus(int i) {
        return i == this.consensus_pos[0] || i == this.consensus_pos[1] || i == this.consensus_pos[2];
    }

    public Codon alt_cons_codon(int coff, char other) {
        System.err.println("FIX ME: replace w/generate_altered()");
        Codon result = new Codon(this.id);
        for (int i = 0; i < 3; ++i) {
            char base = this.consensus_pos[i] == coff ? other : this.bases[i];
            result.append(base, this.unpadded_pos[i], this.consensus_pos[i]);
        }
        return result;
    }

    public int get_id() {
        return this.id;
    }

    public Codon clone() {
        Codon c = null;
        try {
            c = (Codon)super.clone();
            c.bases = new char[3];
            c.consensus_pos = new int[3];
            c.unpadded_pos = new int[3];
            System.arraycopy(this.bases, 0, c.bases, 0, this.bases.length);
            System.arraycopy(this.consensus_pos, 0, c.consensus_pos, 0, this.consensus_pos.length);
            System.arraycopy(this.unpadded_pos, 0, c.unpadded_pos, 0, this.unpadded_pos.length);
        }
        catch (Exception e) {
            System.err.println("clone error!:" + e);
        }
        return c;
    }

    public Codon generate_altered(int cpos, char variant_nt) {
        Codon altered = this.clone();
        for (int i = 0; i < 3; ++i) {
            if (this.consensus_pos[i] != cpos) continue;
            altered.bases[i] = variant_nt;
            if (!this.is_rc) break;
            altered.bases[i] = this.complement(altered.bases[i]);
            break;
        }
        return altered;
    }

    public char complement(char c) {
        char result = '\u0000';
        switch (c) {
            case 'a': {
                result = 't';
                break;
            }
            case 'A': {
                result = 'T';
                break;
            }
            case 'c': {
                result = 'g';
                break;
            }
            case 'C': {
                result = 'G';
                break;
            }
            case 'g': {
                result = 'c';
                break;
            }
            case 'G': {
                result = 'C';
                break;
            }
            case 't': {
                result = 'a';
                break;
            }
            case 'T': {
                result = 'A';
                break;
            }
            case 'n': {
                result = 'n';
                break;
            }
            case 'N': {
                result = 'N';
                break;
            }
            case '*': {
                result = '*';
                break;
            }
            case '-': {
                result = '-';
                break;
            }
            default: {
                System.err.println("error, don't know how to complement nt " + c);
                result = c;
            }
        }
        return result;
    }

    public void set_codon_number(int i) {
        this.id = i;
    }

    public int get_load_index() {
        return this.load_index;
    }

    public boolean is_spliced() {
        return Math.abs(this.unpadded_pos[0] - this.unpadded_pos[2]) != 2;
    }

    public void intron_splice_adjust(IntronCompressor ic, PadMap pm) {
        for (int i = 0; i < 3; ++i) {
            int offset = ic.get_start_shift(this.consensus_pos[i], false);
            int n = i;
            this.consensus_pos[n] = this.consensus_pos[n] - offset;
            this.unpadded_pos[i] = pm.get_padded_to_unpadded(this.consensus_pos[i]);
        }
    }
}

