/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Counter;
import Ace2.SAMQuery;
import Ace2.SAMRegion;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;

public class ConsensusExtender {
    SamReader reader;
    int MIN_READS_TO_EXTEND = 10;
    double MIN_POPULATION_FREQUENCY_TO_EXTEND = 0.95f;
    static boolean VERBOSE = false;

    public ConsensusExtender(SamReader reader) {
        this.reader = reader;
    }

    public String get_extension(String ref_name, boolean extend_r) {
        boolean extendable;
        Object result = null;
        SAMFileHeader h = this.reader.getFileHeader();
        SAMSequenceRecord ssr = h.getSequence(ref_name);
        if (ssr == null) {
            System.err.println("ERROR: no header record for " + ref_name);
            return null;
        }
        int slen = ssr.getSequenceLength();
        SAMQuery sq = new SAMQuery(this.reader);
        SAMRegion sr_q = new SAMRegion(ref_name);
        if (extend_r) {
            sr_q.range.start = sr_q.range.end = slen;
        } else {
            sr_q.range.end = 1;
            sr_q.range.start = 1;
        }
        SAMRecordIterator query = sq.query(sr_q);
        Counter all_candidates = new Counter();
        while (query.hasNext()) {
            SAMRecord sr = (SAMRecord)query.next();
            if (sr.getReadUnmappedFlag()) continue;
            int ref_base = sr.getUnclippedStart();
            int read_i = 0;
            Cigar c = sr.getCigar();
            byte[] read = sr.getReadBases();
            for (CigarElement ce : c.getCigarElements()) {
                CigarOperator co = ce.getOperator();
                int len = ce.getLength();
                if (co.equals((Object)CigarOperator.MATCH_OR_MISMATCH)) {
                    ref_base += len;
                    read_i += len;
                    continue;
                }
                if (co.equals((Object)CigarOperator.SOFT_CLIP)) {
                    if (extend_r) {
                        if (ref_base == slen + 1) {
                            all_candidates.increment(new String(read, read_i, len));
                        }
                    } else {
                        int ref_end = ref_base + len;
                        if (ref_end == 1) {
                            all_candidates.increment(new String(read, read_i, len));
                        }
                    }
                    ref_base += len;
                    read_i += len;
                    continue;
                }
                if (co.equals((Object)CigarOperator.SKIPPED_REGION)) {
                    ref_base += len;
                    continue;
                }
                if (co.equals((Object)CigarOperator.INSERTION)) {
                    read_i += len;
                    continue;
                }
                if (co.equals((Object)CigarOperator.DELETION)) {
                    ref_base += len;
                    continue;
                }
                System.err.println("unhandled CIGAR operator " + co);
                System.exit(1);
            }
        }
        query.close();
        String accepted_extension_sequence = null;
        do {
            int extend_length_attempt = (accepted_extension_sequence == null ? 0 : accepted_extension_sequence.length()) + 1;
            Counter c = new Counter();
            Counter too_short = new Counter();
            for (String s : all_candidates.keySet()) {
                if (s.length() >= extend_length_attempt) {
                    String chunk = extend_r ? s.substring(0, extend_length_attempt) : s.substring(s.length() - extend_length_attempt);
                    c.add(chunk, all_candidates.get_count(s));
                    continue;
                }
                too_short.add(s, all_candidates.get_count(s));
            }
            long total = c.get_total();
            if (VERBOSE) {
                System.err.println("pop:" + total + " short_pop:" + too_short.get_total());
            }
            extendable = true;
            String extend_chunk = null;
            double extend_freq = -1.0;
            for (String seq : c.keySet()) {
                double count = c.get_count(seq);
                double raw_freq = count / (double)total;
                Counter short_hit = new Counter();
                Counter short_miss = new Counter();
                if (VERBOSE) {
                    System.err.println("check " + seq);
                }
                for (String short_seq : too_short.keySet()) {
                    boolean hit;
                    if (extend_r) {
                        hit = seq.indexOf(short_seq) == 0;
                    } else {
                        boolean bl = hit = seq.lastIndexOf(short_seq) == seq.length() - short_seq.length();
                    }
                    if (VERBOSE) {
                        System.err.println("  short check: " + short_seq + ": " + hit + " " + too_short.get_count(short_seq));
                    }
                    if (hit) {
                        short_hit.add(short_seq, too_short.get_count(short_seq));
                        continue;
                    }
                    short_miss.add(short_seq, too_short.get_count(short_seq));
                }
                double full_total = total + short_hit.get_total() + short_miss.get_total();
                double full_count = count + (double)short_hit.get_total();
                double full_freq = full_count / full_total;
                if (VERBOSE) {
                    System.err.println("  short: hits: " + short_hit.get_total() + " miss:" + short_miss.get_total());
                }
                if (VERBOSE) {
                    System.err.println("  raw_freq = " + raw_freq + " full_freq=" + full_freq);
                }
                if (!(count >= (double)this.MIN_READS_TO_EXTEND) || !(full_freq >= this.MIN_POPULATION_FREQUENCY_TO_EXTEND)) continue;
                extend_chunk = seq;
                extend_freq = raw_freq;
                break;
            }
            if (extend_chunk == null) {
                if (VERBOSE) {
                    System.err.println("stopping extension");
                }
                extendable = false;
                continue;
            }
            if (VERBOSE) {
                System.err.println("ACCEPT extension of " + extend_chunk + " with count " + c.get_count(extend_chunk));
            }
            accepted_extension_sequence = extend_chunk;
        } while (extendable);
        return accepted_extension_sequence;
    }
}

