/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Funk.Str;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Counter {
    private HashMap<String, Long> counts = new HashMap();

    public long increment(String label) {
        return this.add(label, 1L);
    }

    public long add(String label, long increment) {
        Long v = this.counts.get(label);
        if (v == null) {
            v = 0L;
        }
        v = v + increment;
        this.counts.put(label, v);
        return v;
    }

    public long get_count(String label) {
        return this.counts.get(label);
    }

    public long get_total() {
        long result = 0L;
        for (String label : this.counts.keySet()) {
            result += this.counts.get(label).longValue();
        }
        return result;
    }

    public static void main(String[] argv) {
        Counter c = new Counter();
        c.increment("duplicate");
        c.increment("else");
        c.increment("duplicate");
        c.increment("three");
        c.increment("three");
        c.increment("three");
        System.err.println("total=" + c.get_total());
        System.err.println("summary=" + c.get_summary());
        c.get_by_incidence();
    }

    public HashMap<String, Long> get_counts() {
        return this.counts;
    }

    public Set<String> keySet() {
        return this.counts.keySet();
    }

    public String get_summary() {
        ArrayList<String> labels = new ArrayList<String>(this.counts.keySet());
        Collections.sort(labels);
        ArrayList<String> things = new ArrayList<String>();
        for (String l : labels) {
            things.add(l + "=" + this.counts.get(l));
        }
        return Str.join(" ", things);
    }

    public ArrayList<String> get_by_incidence() {
        HashMap<Long, ArrayList<String>> by_size = new HashMap<Long, ArrayList<String>>();
        ArrayList<String> results = new ArrayList<String>();
        for (String label : this.counts.keySet()) {
            Long count = (long)this.counts.get(label);
            ArrayList<String> hits = (ArrayList<String>)by_size.get(count);
            if (hits == null) {
                hits = new ArrayList<String>();
                by_size.put(count, hits);
            }
            hits.add(label);
        }
        ArrayList sizes = new ArrayList(by_size.keySet());
        Collections.sort(sizes, Collections.reverseOrder());
        for (Long size : sizes) {
            results.addAll((Collection)by_size.get(size));
        }
        return results;
    }
}

