/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.ChromosomeDisambiguator;
import Ace2.Range;
import Ace2.Reporter;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExonIntronCoverage {
    private SamReader reader;
    private ChromosomeDisambiguator cd;
    boolean SKIP_OPTICAL_DUPLICATES = true;
    int FUZZY_CLASSIFICATION_MIN_ALIGNED_BASES = 30;
    double FUZZY_CLASSIFICATION_ALIGN_FRACTION = 0.9;
    double FUZZY_CLASSIFICATION_OVERLAP_FRACTION = 1.0 - this.FUZZY_CLASSIFICATION_ALIGN_FRACTION;
    HashMap<String, String> annotations;
    static boolean VERBOSE = false;

    public void set_bam(File f) {
        this.reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(f);
        this.cd = new ChromosomeDisambiguator(this.reader);
    }

    public void find_coverage(String reference_name, ArrayList<Range> exons, Reporter rpt) throws Exception {
        this.find_coverage(reference_name, exons);
        this.populate_row(rpt);
    }

    public void find_coverage(String reference_name, ArrayList<Range> exons) throws Exception {
        int start = exons.get((int)0).start;
        int end = exons.get((int)(exons.size() - 1)).end;
        HashSet<Integer> bases_intron = new HashSet<Integer>();
        for (int i = start; i <= end; ++i) {
            bases_intron.add(i);
        }
        this.annotations = new HashMap();
        HashSet<Integer> bases_exon = new HashSet<Integer>();
        for (Range exon : exons) {
            for (int i = exon.start; i <= exon.end; ++i) {
                bases_exon.add(i);
                bases_intron.remove(i);
            }
        }
        String bam_ref_name = this.cd.find(reference_name);
        System.err.println("start query for " + bam_ref_name + ":" + start + "-" + end);
        SAMRecordIterator iterator = this.reader.queryOverlapping(bam_ref_name, start, end);
        int read_count_exon_only = 0;
        int read_count_intron_only = 0;
        int read_count_overlap = 0;
        int read_count_span = 0;
        int read_count_fuzzy_exon = 0;
        int read_count_fuzzy_intron = 0;
        int read_count_fuzzy_overlap = 0;
        int total_reads = 0;
        while (iterator.hasNext()) {
            int total_aligned;
            SAMRecord sr = (SAMRecord)iterator.next();
            if (VERBOSE) {
                System.err.println("read=" + sr.getReadName() + " dup=" + sr.getDuplicateReadFlag() + " strand=" + (sr.getReadNegativeStrandFlag() ? "-" : "+"));
            }
            if (this.SKIP_OPTICAL_DUPLICATES && sr.getDuplicateReadFlag() || sr.getReadUnmappedFlag()) continue;
            ++total_reads;
            if (VERBOSE) {
                System.err.println("OK_read=" + sr.getReadName() + " dup=" + sr.getDuplicateReadFlag() + " strand=" + (sr.getReadNegativeStrandFlag() ? "-" : "+") + " CIGAR=" + sr.getCigar());
            }
            int exon_bases = 0;
            int intron_bases = 0;
            for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                int blen = ab.getLength();
                int ref_base_num = ab.getReferenceStart();
                int last_ref_bn = ref_base_num + blen - 1;
                if (VERBOSE) {
                    System.err.println("block " + sr.getReadName() + ": " + ref_base_num + "-" + last_ref_bn);
                }
                for (int bn = ref_base_num; bn <= last_ref_bn; ++bn) {
                    if (bn < start || bn > end) continue;
                    if (bases_intron.contains(bn)) {
                        ++intron_bases;
                        continue;
                    }
                    if (bases_exon.contains(bn)) {
                        ++exon_bases;
                        continue;
                    }
                    System.err.println("EPIC FAIL");
                }
            }
            if (intron_bases > 0 && exon_bases > 0) {
                ++read_count_overlap;
            } else if (intron_bases > 0) {
                ++read_count_intron_only;
            } else if (exon_bases > 0) {
                ++read_count_exon_only;
            } else {
                ++read_count_span;
            }
            if ((total_aligned = intron_bases + exon_bases) < this.FUZZY_CLASSIFICATION_MIN_ALIGNED_BASES) continue;
            double frac_exon = (double)exon_bases / (double)total_aligned;
            double frac_intron = (double)intron_bases / (double)total_aligned;
            if (frac_exon >= this.FUZZY_CLASSIFICATION_ALIGN_FRACTION) {
                ++read_count_fuzzy_exon;
                continue;
            }
            if (frac_intron >= this.FUZZY_CLASSIFICATION_ALIGN_FRACTION) {
                ++read_count_fuzzy_intron;
                continue;
            }
            if (!(frac_exon >= this.FUZZY_CLASSIFICATION_OVERLAP_FRACTION) || !(frac_intron >= this.FUZZY_CLASSIFICATION_OVERLAP_FRACTION)) continue;
            ++read_count_fuzzy_overlap;
        }
        iterator.close();
        if (total_reads != read_count_exon_only + read_count_intron_only + read_count_overlap + read_count_span) {
            System.err.println("ERROR: total count mismatch");
        }
        this.annotations.put("reference", reference_name);
        this.annotations.put("start", Integer.toString(start));
        this.annotations.put("end", Integer.toString(end));
        this.annotations.put("count_exon_bases", Integer.toString(bases_exon.size()));
        this.annotations.put("count_intron_bases", Integer.toString(bases_intron.size()));
        this.annotations.put("count_reads_exon_exclusive", Integer.toString(read_count_exon_only));
        this.annotations.put("count_reads_intron_exclusive", Integer.toString(read_count_intron_only));
        this.annotations.put("count_reads_overlap", Integer.toString(read_count_overlap));
        int t2 = read_count_exon_only + read_count_intron_only;
        double frac_exclusive_intron = (double)read_count_intron_only / (double)t2;
        this.annotations.put("fraction_exclusive_reads_intron", Double.toString(frac_exclusive_intron));
        this.annotations.put("count_reads_fuzzy_intronic", Integer.toString(read_count_fuzzy_intron));
        this.annotations.put("count_reads_fuzzy_exonic", Integer.toString(read_count_fuzzy_exon));
        this.annotations.put("count_reads_fuzzy_overlap", Integer.toString(read_count_fuzzy_overlap));
        t2 = read_count_fuzzy_intron + read_count_fuzzy_exon;
        double frac_fuzzy_intron = (double)read_count_fuzzy_intron / (double)t2;
        this.annotations.put("fraction_reads_fuzzy_intronic", Double.toString(frac_fuzzy_intron));
    }

    public void populate_row(Reporter r) {
        for (String key : this.annotations.keySet()) {
            r.set_value(key, this.annotations.get(key));
        }
    }
}

