/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.FAIIndexRecord;
import Ace2.FASTAFileTools;
import Ace2.ReferenceSequence;
import Ace2.SAMUtils;
import htsjdk.samtools.cram.ref.ReferenceSource;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FASTADirectory
implements ReferenceSequence {
    ArrayList<String> file_suffixes;
    private String fa_dir;

    public FASTADirectory(String directory) {
        this.fa_dir = directory;
        this.file_suffixes = new ArrayList();
        this.file_suffixes.add("fa");
        this.file_suffixes.add("fasta");
    }

    @Override
    public byte[] get_region(String sequence_name, int start_base, int length) throws IOException {
        byte[] results = null;
        File f = this.find_fasta_file(sequence_name);
        if (f != null) {
            RandomAccessFile raf = new RandomAccessFile(f, "r");
            FASTAFileTools ffp = new FASTAFileTools();
            ffp.detect_record_properties(raf);
            results = ffp.get_region(raf, start_base, length);
        }
        return results;
    }

    @Override
    public byte[] get_all(String sequence_name) throws IOException {
        byte[] results = null;
        File f = this.find_fasta_file(sequence_name);
        if (f != null) {
            RandomAccessFile raf = new RandomAccessFile(f, "r");
            FASTAFileTools ffp = new FASTAFileTools();
            ffp.detect_record_properties(raf);
            results = ffp.get_all(raf);
        }
        return results;
    }

    @Override
    public int get_length(String sequence_name) throws IOException {
        File f = this.find_fasta_file(sequence_name);
        int result = -1;
        if (f != null) {
            RandomAccessFile raf = new RandomAccessFile(f, "r");
            FASTAFileTools ffp = new FASTAFileTools();
            FAIIndexRecord index = ffp.detect_record_properties(raf);
            result = index.sequence_length;
            raf.close();
        }
        return result;
    }

    public File find_fasta_file(String sequence_name) {
        File result = null;
        for (String key : SAMUtils.get_refname_alternates(sequence_name)) {
            for (String suffix : this.file_suffixes) {
                String fq = this.fa_dir + File.separator + key + "." + suffix;
                File f = new File(fq);
                if (!f.exists()) continue;
                result = f;
                break;
            }
            if (result == null) continue;
            break;
        }
        if (result == null) {
            System.err.println("WARNING: can't find FASTA file for " + sequence_name);
        }
        return result;
    }

    public static void main(String[] argv) {
        try {
            FASTADirectory fad = new FASTADirectory("c:\\generatable\\hg18");
            String id = "chr17_mini";
            System.err.println("len=" + fad.get_length(id));
            byte[] sequence_all = fad.get_all(id);
            System.err.println("read len=" + sequence_all.length);
            System.err.println("full=" + new String(sequence_all));
            byte[] sequence_excerpt = fad.get_region(id, 40, 40);
            System.err.println("got=" + new String(sequence_excerpt));
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
    }

    @Override
    public boolean supports_sequence_list() {
        return true;
    }

    @Override
    public ArrayList<String> get_sequence_names() {
        ArrayList<String> results = null;
        System.err.println("FIX ME: FASTADirectory.get_sequence_list() not implemented");
        return results;
    }

    @Override
    public ReferenceSource getReferenceSource() {
        System.err.println("ERROR: getReferenceSource() not implemented");
        return null;
    }
}

