/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import java.io.IOException;
import java.io.RandomAccessFile;

public class FASTAFileProperties {
    private long fa_ptr_id;
    private long fa_ptr_sequence;
    private long fa_cooked_line_nt;
    private long fa_raw_line_bytes;
    private int line_overhead;
    private long sequence_length;

    public void detect_record_properties(RandomAccessFile raf) throws IOException {
        this.fa_ptr_id = raf.getFilePointer();
        String id_line = raf.readLine();
        if (id_line.indexOf(">") == 0) {
            this.fa_ptr_sequence = raf.getFilePointer();
            String first_sequence_line = raf.readLine();
            long ptr_second = raf.getFilePointer();
            this.fa_raw_line_bytes = ptr_second - this.fa_ptr_sequence;
            this.fa_cooked_line_nt = first_sequence_line.length();
            long flen = raf.length();
            long body_size = flen - this.fa_ptr_sequence;
            long lines = body_size / this.fa_raw_line_bytes;
            this.line_overhead = (int)(this.fa_raw_line_bytes - this.fa_cooked_line_nt);
            long leftover = body_size % this.fa_raw_line_bytes;
            if (leftover > 0L) {
                leftover -= (long)this.line_overhead;
            }
            this.sequence_length = lines * this.fa_cooked_line_nt + leftover;
        } else {
            System.err.println("ERROR: expected FASTA ID line, got " + id_line);
        }
    }

    public long get_sequence_length() {
        return this.sequence_length;
    }

    public long get_sequence_pointer() {
        return this.fa_ptr_sequence;
    }

    public long get_raw_bytes_per_line() {
        return this.fa_raw_line_bytes;
    }

    public int get_line_overhead() {
        return this.line_overhead;
    }

    public long get_nt_per_line() {
        return this.fa_cooked_line_nt;
    }
}

