/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AceViewer;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FASTAQualityReader
implements Runnable {
    private BufferedReader br;
    private boolean data_loaded = false;
    private HashMap<String, ArrayList<Integer>> quals;
    private AceViewer av;

    public FASTAQualityReader(BufferedReader br, AceViewer av, boolean async) {
        this.br = br;
        this.av = av;
        this.setup(async);
    }

    public FASTAQualityReader(BufferedReader br, boolean async) {
        this.br = br;
        this.setup(async);
    }

    private void setup(boolean async) {
        if (async) {
            Thread t = new Thread(this);
            t.start();
        } else {
            this.run();
        }
    }

    @Override
    public void run() {
        String id = null;
        this.quals = new HashMap();
        try {
            String line;
            while ((line = this.br.readLine()) != null) {
                if (line.indexOf(">") == 0) {
                    id = line.substring(1);
                    continue;
                }
                ArrayList<Integer> list = this.quals.get(id);
                if (list == null) {
                    list = new ArrayList();
                    this.quals.put(id, list);
                }
                String[] q = line.split(" ");
                int i = 0;
                for (i = 0; i < q.length; ++i) {
                    list.add(Integer.parseInt(q[i]));
                }
            }
            this.data_loaded = true;
            if (this.av != null) {
                while (!this.av.get_acepanel().get_assembly().alignment_is_built()) {
                    try {
                        System.err.println("FASTAQualityReader spin...");
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {}
                }
                this.av.get_acepanel().get_assembly().set_quality(this);
                this.av.repaint();
            }
        }
        catch (Exception e) {
            System.err.println("FASTAQualityReader load error: " + e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] argv) {
        try {
            URL url = new URL(argv[0]);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            FASTAQualityReader fASTAQualityReader = new FASTAQualityReader(br, null, false);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public HashMap<String, ArrayList<Integer>> get_quality() {
        return this.quals;
    }
}

