/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Assembly;
import Ace2.AssemblySequence;
import Ace2.Base;
import Ace2.BaseCountInfo;
import Ace2.BaseCounter3;
import Ace2.Sample;
import Funk.Str;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;

public class Genotyper {
    private Assembly assembly;
    private BaseCounter3 bc;
    private ArrayList<Base> bases;
    private HashMap<Sample, EnumMap<Base, Integer>> counts;

    public Genotyper(Assembly assembly, BaseCounter3 bc, char b1, char b2) {
        this.assembly = assembly;
        this.bc = bc;
        this.bases = new ArrayList();
        this.bases.add(Base.valueOf(b1));
        this.bases.add(Base.valueOf(b2));
        this.setup();
    }

    public Genotyper(Assembly assembly, BaseCounter3 bc, Base b1, Base b2) {
        this.assembly = assembly;
        this.bc = bc;
        this.bases = new ArrayList();
        this.bases.add(b1);
        this.bases.add(b2);
        this.setup();
    }

    private void setup() {
        this.counts = new HashMap();
        for (Base base : this.bases) {
            BaseCountInfo bci = this.bc.get_info(base);
            if (bci == null) continue;
            for (Object o : bci.sequences) {
                Integer count;
                AssemblySequence as = (AssemblySequence)o;
                Sample sample = this.assembly.get_sample_for(as.get_name());
                EnumMap<Base, Integer> counter = this.counts.get(sample);
                if (counter == null) {
                    counter = new EnumMap(Base.class);
                    this.counts.put(sample, counter);
                }
                if ((count = counter.get((Object)base)) == null) {
                    count = 0;
                }
                counter.put(base, count + 1);
            }
        }
    }

    public String get_summary() {
        ArrayList<String> blocks = new ArrayList<String>();
        for (Sample sample : this.counts.keySet()) {
            EnumMap<Base, Integer> counter = this.counts.get(sample);
            ArrayList<String> block = new ArrayList<String>();
            String sample_id = sample.get_sample_name();
            block.add(sample_id == null ? "unknown_sample" : sample_id);
            for (Base base : this.bases) {
                block.add(base.toString());
                Integer count = this.counts.get(sample).get((Object)base);
                if (count == null) {
                    count = 0;
                }
                block.add(count.toString());
            }
            if (block.size() <= 0) continue;
            blocks.add(Str.join(",", block));
        }
        return blocks.size() == 0 ? "" : Str.join(" ", blocks);
    }
}

