/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.GermlineSomaticTestCase;
import java.util.ArrayList;

public class GermlineSomaticLOH {
    private static final int MIN_ALLELE_COVERAGE_TO_CALL = 4;
    private static final float LOH_WIGGLE_FRACTION = 0.05f;
    private static final float MIN_GERMLINE_NORMAL_ALLELE_FREQUENCY = 0.15f;
    private boolean too_low;
    private boolean somatic;
    private boolean germline;
    private float alt_n_freq;
    private float alt_t_freq;
    private float ref_n_freq;
    private float ref_t_freq;
    private float alt_tn_freq_diff;
    private int loh;
    public static final int LOH_NO_LOH = 0;
    public static final int LOH_LOSS_OF_REFERENCE_ALLELE = 1;
    public static final int LOH_LOSS_OF_VARIANT_ALLELE = 2;

    public boolean call(GermlineSomaticTestCase tcase) {
        return this.call(tcase.ref_n_count, tcase.ref_t_count, tcase.alt_n_count, tcase.alt_t_count);
    }

    public boolean call(int ref_n_count, int ref_t_count, int alt_n_count, int alt_t_count) {
        this.germline = false;
        this.somatic = false;
        this.too_low = false;
        this.loh = 0;
        int n_total = ref_n_count + alt_n_count;
        int t_total = ref_t_count + alt_t_count;
        this.alt_n_freq = n_total == 0 ? 0.0f : (float)alt_n_count / (float)n_total;
        this.alt_t_freq = t_total == 0 ? 0.0f : (float)alt_t_count / (float)t_total;
        this.ref_n_freq = n_total == 0 ? 0.0f : (float)ref_n_count / (float)n_total;
        this.ref_t_freq = t_total == 0 ? 0.0f : (float)ref_t_count / (float)t_total;
        this.alt_tn_freq_diff = this.alt_t_freq - this.alt_n_freq;
        if (ref_n_count >= 4 && alt_t_count >= 4 || n_total > 4 && t_total > 4) {
            boolean somatic_criteria_high = (double)this.alt_tn_freq_diff >= 0.5 && (double)this.alt_n_freq <= 0.01 && ref_n_count >= 4 && alt_t_count >= 5;
            boolean somatic_criteria_medium = (double)this.alt_tn_freq_diff >= 0.2 && (double)this.alt_tn_freq_diff < 0.5 && (double)this.alt_n_freq <= 0.01 && ref_n_count >= 20 && alt_t_count >= 4;
            boolean somatic_criteria_low = (double)this.alt_tn_freq_diff >= 0.1 && (double)this.alt_tn_freq_diff < 0.2 && (double)this.alt_n_freq <= 0.01 && ref_n_count >= 30 && alt_t_count >= 4;
            this.somatic = somatic_criteria_high || somatic_criteria_medium || somatic_criteria_low;
            boolean bl = this.germline = this.alt_n_freq >= 0.15f;
            if (this.ref_n_freq >= 0.15f && this.alt_n_freq >= 0.15f) {
                if (this.alt_t_freq >= 0.15f && this.ref_t_freq <= 0.05f) {
                    this.loh = 1;
                } else if (this.ref_t_freq >= 0.15f && this.alt_t_freq <= 0.05f) {
                    this.loh = 2;
                }
            }
        } else {
            this.too_low = true;
        }
        return !this.too_low;
    }

    public boolean is_loh() {
        return this.loh != 0;
    }

    public int get_loh_type() {
        return this.loh;
    }

    public boolean is_somatic() {
        return this.somatic;
    }

    public boolean is_germline() {
        return this.germline;
    }

    public static void main(String[] argv) {
        ArrayList<GermlineSomaticTestCase> cases = new ArrayList<GermlineSomaticTestCase>();
        if (argv.length == 4) {
            cases.add(new GermlineSomaticTestCase("command-line specified", Integer.parseInt(argv[0]), Integer.parseInt(argv[1]), Integer.parseInt(argv[2]), Integer.parseInt(argv[3])));
        } else {
            System.err.println("specify: ref_count_normal ref_count_tumor alt_count_normal alt_count_tumor");
            System.err.println("running tests:");
            cases.add(new GermlineSomaticTestCase("LOH (loss of reference)", 5, 0, 5, 10));
            cases.add(new GermlineSomaticTestCase("LOH (loss of variant)", 5, 10, 5, 0));
        }
        for (GermlineSomaticTestCase tcase : cases) {
            System.err.println("desc:" + tcase.description + " " + "ref_n:" + tcase.ref_n_count + " " + "ref_t:" + tcase.ref_t_count + " " + "alt_n:" + tcase.alt_n_count + " " + "alt_t:" + tcase.alt_t_count);
            GermlineSomaticLOH gsl = new GermlineSomaticLOH();
            boolean call = gsl.call(tcase);
            System.err.println("     callable: " + call);
            System.err.println("  is_germline: " + gsl.is_germline());
            System.err.println("  is_somatic: " + gsl.is_somatic());
            System.err.println("      is_loh: " + gsl.is_loh() + " type=" + gsl.get_loh_type());
            System.err.println("  alt_freq_n: " + gsl.get_alt_freq_normal());
            System.err.println("  alt_freq_t: " + gsl.get_alt_freq_tumor());
            System.err.println("        diff: " + gsl.get_alt_tn_freq_diff());
            System.err.println("");
        }
    }

    public float get_alt_freq_normal() {
        return this.alt_n_freq;
    }

    public float get_alt_freq_tumor() {
        return this.alt_t_freq;
    }

    public float get_alt_tn_freq_diff() {
        return this.alt_tn_freq_diff;
    }
}

