/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Funk.Str;
import htsjdk.samtools.CigarOperator;
import java.util.ArrayList;

public class IndelEvent {
    CigarOperator indel_type;
    int reference_base;
    int length;
    int count;
    String sequence;
    static final String HASH_KEY_DELIM = "_";
    String hash_key;

    public IndelEvent(CigarOperator indel_type, int reference_base, int length, String sequence) {
        this.indel_type = indel_type;
        this.reference_base = reference_base;
        this.length = length;
        this.sequence = sequence;
        if (sequence != null) {
            sequence = sequence.toUpperCase();
        }
        boolean count = false;
        ArrayList<String> key_elements = new ArrayList<String>();
        key_elements.add(indel_type.toString());
        key_elements.add(Integer.toString(reference_base));
        key_elements.add(Integer.toString(length));
        if (!indel_type.equals((Object)CigarOperator.DELETION)) {
            if (indel_type.equals((Object)CigarOperator.INSERTION)) {
                key_elements.add(sequence);
            } else {
                System.err.println("ERROR");
            }
        }
        this.hash_key = Str.join(HASH_KEY_DELIM, key_elements);
    }

    public boolean is_insertion() {
        return this.indel_type.equals((Object)CigarOperator.INSERTION);
    }

    public boolean is_deletion() {
        return this.indel_type.equals((Object)CigarOperator.DELETION);
    }

    public String get_hash_key() {
        return this.hash_key;
    }

    public String toString() {
        return this.hash_key;
    }
}

