/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndelInfo {
    CigarOperator indel_type;
    int reference_i;
    int length;
    SAMRecord sr;
    String sequence;
    byte tumor_normal;
    byte quality;
    int minimum_flanking_sequence;

    public IndelInfo(CigarOperator indel_type, int reference_i, int length, SAMRecord sr, int read_i) {
        this.indel_type = indel_type;
        this.reference_i = reference_i;
        this.length = length;
        this.sequence = null;
        this.set_minimum_flanking_sequence(sr, read_i);
        this.set_quality(sr, read_i);
    }

    public String getTypeHashString() {
        return this.indel_type.toString() + this.length;
    }

    private void set_quality(SAMRecord sr, int read_i) {
        int start = -1;
        int end = -1;
        if (this.indel_type.equals((Object)CigarOperator.DELETION)) {
            start = read_i - 1;
            end = read_i;
        } else if (this.indel_type.equals((Object)CigarOperator.INSERTION)) {
            start = read_i;
            end = read_i + (this.length - 1);
        }
        if (start == -1 || end == -1) {
            this.quality = (byte)-1;
        } else {
            int count = 0;
            int total = 0;
            if (sr == null) {
                System.err.println("WTF?");
            }
            byte[] qual = sr.getBaseQualities();
            int i = start;
            while (i <= end) {
                total += qual[i];
                ++i;
                ++count;
            }
            this.quality = (byte)(total / count);
        }
    }

    private void set_minimum_flanking_sequence(SAMRecord sr, int read_i) {
        int flank_l = read_i;
        int flank_r = sr.getReadLength() - (read_i + (this.indel_type.equals((Object)CigarOperator.INSERTION) ? this.length : 1));
        this.minimum_flanking_sequence = flank_l < flank_r ? flank_l : flank_r;
    }

    public static HashSet<String> get_insertion_sequences(ArrayList<IndelInfo> iis) {
        HashSet<String> seqs = new HashSet<String>();
        for (IndelInfo ii : iis) {
            if (ii.sequence == null) continue;
            seqs.add(ii.sequence);
        }
        return seqs;
    }
}

