/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Funk.Str;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCCache {
    private String DB_SERVER = "my_server";
    private String DB_DATABASE = "my_database";
    private String DB_USER = "my_user";
    private String DB_PASSWORD = "my_password";
    public static String UCSC_DB_SERVER = "genome-mysql.cse.ucsc.edu";
    public static String UCSC_DB_DATABASE = "hg18";
    public static String UCSC_DB_USERNAME = "genome";
    public static String UCSC_DB_PASSWORD = "";
    public static String UCSC_SNP_TABLE = "snp129";
    private Preferences cache;
    private ArrayList<HashMap<String, String>> results;
    private static final String KEY_DELIM = "\t";
    private static final String KEY_TABLE_COLS = "__cols";
    private static final String VALUE_NULL_SET = "___NULL_SET___";
    private Connection connection = null;

    public JDBCCache() {
        this.setup();
    }

    public static JDBCCache get_ucsc_genome_client() {
        JDBCCache c = new JDBCCache();
        c.set_db_server(UCSC_DB_SERVER);
        c.set_db_database(UCSC_DB_DATABASE);
        c.set_db_user(UCSC_DB_USERNAME);
        c.set_db_password(UCSC_DB_PASSWORD);
        return c;
    }

    public void set_db_server(String s) {
        this.DB_SERVER = s;
    }

    public void set_db_database(String s) {
        this.DB_DATABASE = s;
    }

    public void set_db_user(String s) {
        this.DB_USER = s;
    }

    public void set_db_password(String s) {
        this.DB_PASSWORD = s;
    }

    private void setup() {
        this.cache = Preferences.userNodeForPackage(this.getClass());
    }

    private Connection get_connection() throws SQLException {
        if (this.connection == null) {
            String cs = "jdbc:mysql://" + this.DB_SERVER + "/" + this.DB_DATABASE + "?user=" + this.DB_USER;
            if (this.DB_PASSWORD != null && this.DB_PASSWORD.length() > 0) {
                cs = cs.concat("&password=" + this.DB_PASSWORD);
            }
            System.err.println("cs=" + cs);
            this.connection = DriverManager.getConnection(cs);
        }
        return this.connection;
    }

    public byte[] string2ba(String ins) {
        char[] input = ins.toCharArray();
        byte[] output = new byte[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = (byte)input[i];
        }
        return output;
    }

    public synchronized ArrayList<HashMap<String, String>> query(String query) throws Exception {
        String key;
        String value;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.reset();
        md5.update(this.string2ba(this.DB_SERVER));
        md5.update(this.string2ba(this.DB_DATABASE));
        md5.update(this.string2ba(query));
        String key_base = new String(md5.digest());
        this.results = new ArrayList();
        int ri = 0;
        boolean have_cache = false;
        ArrayList<String> columns = null;
        while ((value = this.cache.get(key = key_base + KEY_DELIM + ri++, "")).length() != 0) {
            if (value.equals(VALUE_NULL_SET)) {
                System.err.println("JDBC cache: null result set!");
                have_cache = true;
                break;
            }
            have_cache = true;
            String[] f = value.split(KEY_DELIM);
            if (columns == null) {
                columns = new ArrayList<String>();
                for (int i = 0; i < f.length; ++i) {
                    columns.add(f[i]);
                }
                continue;
            }
            HashMap row = new HashMap();
            for (int i = 0; i < f.length; ++i) {
                row.put(columns.get(i), new String(f[i]));
            }
            this.results.add(row);
        }
        if (!have_cache) {
            System.err.println("database query needed");
            Connection c = this.get_connection();
            Statement st = c.createStatement();
            if (st.execute(query)) {
                ResultSet rs = st.getResultSet();
                ResultSetMetaData meta = rs.getMetaData();
                int cc = meta.getColumnCount();
                columns = new ArrayList();
                for (int i = 1; i <= cc; ++i) {
                    columns.add(meta.getColumnName(i));
                }
                boolean need_headers = true;
                int row_count = 0;
                while (rs.next()) {
                    ++row_count;
                    HashMap row = new HashMap();
                    ArrayList<String> raw = new ArrayList<String>();
                    for (int i = 1; i <= cc; ++i) {
                        String value2 = new String(rs.getString(i));
                        raw.add(value2);
                        row.put(columns.get(i - 1), value2);
                    }
                    if (need_headers) {
                        ri = 0;
                        this.cache.put(key_base + KEY_DELIM + ri++, Str.join(KEY_DELIM, columns));
                        need_headers = false;
                    }
                    this.cache.put(key_base + KEY_DELIM + ri++, Str.join(KEY_DELIM, raw));
                    this.results.add(row);
                }
                if (row_count == 0) {
                    ri = 0;
                    this.cache.put(key_base + KEY_DELIM + ri++, VALUE_NULL_SET);
                }
                this.cache.remove(key_base + KEY_DELIM + ri++);
            } else {
                System.err.println("no results!");
            }
        }
        return this.results;
    }

    public int get_result_count() {
        return this.results.size();
    }

    public ArrayList<HashMap<String, String>> get_results() {
        return this.results;
    }

    public void flush_cache() {
        try {
            String[] keys = this.cache.keys();
            for (int i = 0; i < keys.length; ++i) {
                this.cache.remove(keys[i]);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static void main(String[] argv) {
        JDBCCache ucsc = JDBCCache.get_ucsc_genome_client();
        if (argv.length == 1 && argv[0].equals("-flush")) {
            System.err.println("flushing cache");
            ucsc.flush_cache();
        } else {
            try {
                ArrayList<HashMap<String, String>> results = ucsc.query("select * from refGene where name2=\"tp53\"");
                for (HashMap<String, String> row : results) {
                    System.err.println(row.get("name2"));
                }
                System.err.println("count=" + ucsc.get_result_count());
            }
            catch (Exception e) {
                System.err.println("ERROR: " + e);
                e.printStackTrace();
            }
        }
    }
}

