/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.BaseCountInfo;
import Ace2.IndelInfo;
import Ace2.SNPTrackInfo;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JointPolymorphismScore {
    double reference_probability = -1.0;
    double variant_probability = -1.0;
    static final double prior_poly = 0.001;
    static final double prior_not = 0.999;

    public void set_reference_probability(BaseCountInfo bci) {
        this.reference_probability = this.get_probability_product(bci);
    }

    public void set_reference_probability(ArrayList<SNPTrackInfo> stis) {
        this.reference_probability = -1.0;
        for (SNPTrackInfo sti : stis) {
            if (this.reference_probability == -1.0) {
                this.reference_probability = this.quality_to_probability(sti.get_quality());
                continue;
            }
            this.reference_probability *= this.quality_to_probability(sti.get_quality());
        }
    }

    public void set_reference_probability_from_quality(int qual) {
        this.reference_probability = this.quality_to_probability(qual);
    }

    public void set_variant_probability(BaseCountInfo bci) {
        this.variant_probability = this.get_probability_product(bci);
    }

    public void set_variant_probability(ArrayList<IndelInfo> infos) {
        this.variant_probability = -1.0;
        for (IndelInfo ii : infos) {
            if (this.variant_probability == -1.0) {
                this.variant_probability = this.quality_to_probability(ii.quality);
                continue;
            }
            this.variant_probability *= this.quality_to_probability(ii.quality);
        }
    }

    private double quality_to_probability(int qual) {
        return Math.pow(10.0, -qual / 10);
    }

    public double calculate_score() {
        double conditional_poly = (1.0 - this.reference_probability) * (1.0 - this.variant_probability);
        double conditional_not = (1.0 - this.reference_probability) * this.variant_probability + this.reference_probability * (1.0 - this.variant_probability);
        double joint_poly = 0.001 * conditional_poly;
        double joint_not = 0.999 * conditional_not;
        return joint_poly / (joint_poly + joint_not);
    }

    private double get_probability_product(BaseCountInfo bci) {
        double product = -1.0;
        for (Object o : bci.sequences) {
            SNPTrackInfo sti = (SNPTrackInfo)o;
            if (product == -1.0) {
                product = this.quality_to_probability(sti.get_quality());
                continue;
            }
            product *= this.quality_to_probability(sti.get_quality());
        }
        return product;
    }
}

