/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AceViewer;
import Ace2.AceViewerConfig;
import Ace2.ErrorReporter;
import Ace2.FASTADirectory;
import Ace2.FASTAIndexedFAI;
import Ace2.JDBCCache;
import Ace2.NIB;
import Ace2.SAMAssembly;
import Ace2.SAMRegion;
import Ace2.SAMResource;
import Ace2.SAMUtils;
import Ace2.SuffixFileFilter;
import Ace2.TwoBitFile;
import Funk.Str;
import TCGA.URLLauncher;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.sql.SQLException;
import java.util.prefs.Preferences;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.filechooser.FileFilter;
import layout.SpringUtilities;

public class Launcher
extends JFrame
implements ActionListener {
    private AceViewerConfig config;
    private JCheckBox jcb_multi;
    private JCheckBox jcb_use_ref;
    private JCheckBox jcb_load_dups;
    private JCheckBox jcb_enable_jdbc;
    private JCheckBox jcb_db_flush;
    private JTextArea jta;
    SuffixFileFilter ff_bam;
    SuffixFileFilter ff_reference;
    private static final int TYPE_NIB = 1;
    private static final int TYPE_2BIT = 2;
    private static final int TYPE_FASTA_DIR = 3;
    private static final int TYPE_FASTA_FAI = 4;
    private int reference_type = 0;
    private Component deep_sigh = this;
    JFileChooser fc;
    JTextField nib_dir;
    JTextField fn_annotations;
    JTextField jtf_db_database;
    JTextField jtf_db_server;
    JTextField jtf_db_user;
    JTextField jtf_db_password;
    private Preferences prefs;
    private static final String PREF_NIB_PATH = "nib_path";
    private static final String PREF_BAM_FILES = "bam_files";
    private static final String PREF_REFSEQ_TYPE = "refseq_file_type";

    public Launcher(AceViewerConfig config) {
        this.config = config;
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        this.setup();
    }

    private void setup() {
        this.title_setup();
        this.setDefaultCloseOperation(3);
        this.fc = new JFileChooser();
        this.jcb_multi = new JCheckBox("allow multiple files", true);
        this.jcb_multi.setToolTipText("if checked, selecting a file will add it to the list; if unchecked, will reset list");
        this.ff_bam = new SuffixFileFilter("bam");
        this.ff_reference = new SuffixFileFilter();
        this.ff_reference.add_suffix("2bit");
        this.ff_reference.add_suffix("nib");
        this.ff_reference.add_suffix("fasta");
        this.ff_reference.add_suffix("fa");
        JPanel jp_main = new JPanel();
        jp_main.setLayout(new BoxLayout(jp_main, 3));
        JPanel p = new JPanel(new SpringLayout());
        p.add(new JLabel(".bam file(s):", 11));
        this.jta = new JTextArea(4, 80);
        this.jta.setText(this.prefs.get(PREF_BAM_FILES, ""));
        p.add(new JScrollPane(this.jta));
        JButton jb = new JButton("Browse...");
        this.add_paneled_button(p, jb);
        jb.setToolTipText("select a .bam file to view");
        jb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File fn = Launcher.this.get_local_file(Launcher.this.ff_bam);
                if (Launcher.this.jcb_multi.isSelected()) {
                    if (fn != null) {
                        String existing = Launcher.this.jta.getText();
                        if (existing != null && existing.length() > 0) {
                            Launcher.this.jta.append("\n");
                        }
                        Launcher.this.jta.append(fn.toString());
                    }
                } else if (fn == null) {
                    Launcher.this.jta.setText("");
                } else {
                    Launcher.this.jta.setText(fn.toString());
                }
            }
        });
        p.add(new JLabel(""));
        p.add(this.jcb_multi);
        p.add(new JLabel(""));
        p.add(new JLabel("reference sequence:", 11));
        this.nib_dir = new JTextField(80);
        p.add(this.nib_dir);
        this.nib_dir.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                String s = Launcher.this.nib_dir.getText();
                if (s.length() > 0) {
                    Launcher.this.configure_reference_sequence(new File(s));
                }
            }
        });
        String nib_path = this.prefs.get(PREF_NIB_PATH, "");
        this.nib_dir.setText(nib_path);
        if (nib_path.length() > 0) {
            this.reference_type = Integer.parseInt(this.prefs.get(PREF_REFSEQ_TYPE, "0"));
            System.err.println("loaded reference type " + this.reference_type);
            this.configure_reference_sequence(new File(nib_path));
        }
        jb = new JButton("Browse...");
        this.add_paneled_button(p, jb);
        jb.setToolTipText("browse for a reference sequence sequence file in UCSC .2bit or .nib format");
        jb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File fn = Launcher.this.get_local_file(Launcher.this.ff_reference);
                Launcher.this.configure_reference_sequence(fn);
            }
        });
        p.add(new JLabel(""));
        this.jcb_use_ref = new JCheckBox("use reference sequence (recommended)", true);
        p.add(this.jcb_use_ref);
        p.add(new JLabel(""));
        p.add(new JLabel(""));
        p.add(new JLabel("Reference sequence in FASTA (directory or samtools .fai indexed), or UCSC .2bit / .nib formats"));
        p.add(new JLabel(""));
        p.add(new JLabel(""));
        JLabel jl = new JLabel("<html><a href=\"bogus\">click to download hg18.2bit</a>");
        p.add(jl);
        jl.setToolTipText("download and save a binary version of the human reference genome sequence build hg18 to your computer");
        jl.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
                new URLLauncher("ftp://hgdownload.cse.ucsc.edu/gbdb/hg18/nib/hg18.2bit", "hg18");
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        p.add(new JLabel(""));
        this.jcb_use_ref.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox jcb = (JCheckBox)e.getSource();
                Launcher.this.nib_dir.setEnabled(jcb.isSelected());
            }
        });
        SpringUtilities.makeCompactGrid((Container)p, (int)6, (int)3, (int)6, (int)6, (int)6, (int)6);
        jp_main.add(p);
        JPanel jp_options = new JPanel(new SpringLayout());
        this.jcb_load_dups = new JCheckBox("load optical/PCR duplicates", false);
        jp_options.add(this.jcb_load_dups);
        SpringUtilities.makeCompactGrid((Container)jp_options, (int)1, (int)1, (int)6, (int)6, (int)6, (int)6);
        JPanel jp_annot = new JPanel(new SpringLayout());
        this.jtf_db_database = new JTextField(80);
        this.jtf_db_server = new JTextField(80);
        this.jtf_db_user = new JTextField(80);
        this.jtf_db_password = new JTextField(80);
        jp_annot.add(new JLabel(""));
        this.jcb_enable_jdbc = new JCheckBox("Enable database queries", true);
        jp_annot.add(this.jcb_enable_jdbc);
        jp_annot.add(new JLabel(""));
        this.jcb_db_flush = new JCheckBox("Clear database cache", false);
        jp_annot.add(this.jcb_db_flush);
        this.jcb_enable_jdbc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean enabled;
                JCheckBox jcb = (JCheckBox)e.getSource();
                ((Launcher)Launcher.this).config.ENABLE_JDBC = enabled = jcb.isSelected();
                Launcher.this.jtf_db_database.setEnabled(enabled);
                Launcher.this.jtf_db_server.setEnabled(enabled);
                Launcher.this.jtf_db_user.setEnabled(enabled);
                Launcher.this.jtf_db_password.setEnabled(enabled);
            }
        });
        jp_annot.add(new JLabel("Database name:", 11));
        jp_annot.add(this.jtf_db_database);
        this.jtf_db_database.setText(JDBCCache.UCSC_DB_DATABASE);
        jp_annot.add(new JLabel("server:", 11));
        jp_annot.add(this.jtf_db_server);
        this.jtf_db_server.setText(JDBCCache.UCSC_DB_SERVER);
        jp_annot.add(new JLabel("username:", 11));
        jp_annot.add(this.jtf_db_user);
        this.jtf_db_user.setText(JDBCCache.UCSC_DB_USERNAME);
        jp_annot.add(new JLabel("password:", 11));
        jp_annot.add(this.jtf_db_password);
        this.jtf_db_password.setText(JDBCCache.UCSC_DB_PASSWORD);
        SpringUtilities.makeCompactGrid((Container)jp_annot, (int)6, (int)2, (int)6, (int)6, (int)6, (int)6);
        Container cp = this.getContentPane();
        JTabbedPane jtp = new JTabbedPane();
        jtp.add("Data files", jp_main);
        JPanel jp_bogus = new JPanel();
        jp_bogus.add(jp_annot);
        jtp.add("Annotation database", jp_bogus);
        jtp.add("Options", jp_options);
        JPanel jp = new JPanel();
        jb = new JButton("Start viewer");
        jp.add(jb);
        jb.addActionListener(this);
        cp.add("Center", jtp);
        cp.add("South", jp);
        this.pack();
        this.setVisible(true);
    }

    public File get_local_directory() {
        this.fc.resetChoosableFileFilters();
        this.fc.setFileSelectionMode(1);
        return this.fc.showOpenDialog(this) == 0 ? this.fc.getSelectedFile() : null;
    }

    public File get_local_file(FileFilter ff) {
        this.fc.addChoosableFileFilter(ff);
        this.fc.setFileSelectionMode(0);
        return this.fc.showOpenDialog(this) == 0 ? this.fc.getSelectedFile() : null;
    }

    public void actionPerformed(ActionEvent e) {
        String error_msg = null;
        JDBCCache.UCSC_DB_DATABASE = this.jtf_db_database.getText();
        JDBCCache.UCSC_DB_SERVER = this.jtf_db_server.getText();
        JDBCCache.UCSC_DB_USERNAME = this.jtf_db_user.getText();
        JDBCCache.UCSC_DB_PASSWORD = this.jtf_db_password.getText();
        if (this.jcb_db_flush.isSelected()) {
            JDBCCache cache = new JDBCCache();
            cache.flush_cache();
        }
        if (this.jcb_use_ref.isSelected()) {
            String nib_path = this.nib_dir.getText();
            System.err.println("init reference sequence: type=" + this.reference_type + " path=" + nib_path);
            if (nib_path != null && nib_path.length() > 0) {
                File path = new File(nib_path);
                if (this.reference_type == 1) {
                    NIB.DEFAULT_NIB_DIR = nib_path;
                    this.config.reference_sequence = new NIB();
                } else if (this.reference_type == 2) {
                    try {
                        this.config.reference_sequence = new TwoBitFile(nib_path);
                    }
                    catch (Exception exc) {
                        new ErrorReporter(exc);
                    }
                } else if (this.reference_type == 3) {
                    this.config.reference_sequence = new FASTADirectory(nib_path);
                } else if (this.reference_type == 4) {
                    try {
                        this.config.reference_sequence = new FASTAIndexedFAI(nib_path);
                    }
                    catch (Exception exc) {
                        new ErrorReporter(exc);
                    }
                } else {
                    System.err.println("ERROR: don't know how to init reference sequence, type= " + this.reference_type + " path=" + nib_path);
                }
                if (this.config.reference_sequence != null) {
                    this.prefs.put(PREF_NIB_PATH, nib_path);
                    this.prefs.put(PREF_REFSEQ_TYPE, Integer.toString(this.reference_type));
                }
            } else {
                error_msg = "no reference sequence specified.  Uncheck \"use reference sequence\" or download a local copy of reference genome data files.";
            }
        } else {
            this.config.GENERATE_CONSENSUS = true;
        }
        String files = this.jta.getText();
        if (files != null && (files = Str.trim_whitespace(files)).length() > 0) {
            String[] names = files.split("\n");
            for (int i = 0; i < names.length; ++i) {
                String fname = names[i];
                if (fname == null || fname.length() == 0) continue;
                if (fname.toLowerCase().indexOf(".bam") != fname.length() - 4) {
                    error_msg = "Specify only .bam files: file \"" + fname + "\"" + " does not end in .bam";
                    break;
                }
                File f = new File(fname = Str.trim_whitespace(fname));
                if (f.exists()) {
                    if (SAMUtils.is_bam_indexed(f)) {
                        SAMResource sr = new SAMResource();
                        if (!this.jcb_load_dups.isSelected()) {
                            sr.set_load_duplicates(false);
                        }
                        sr.set_file(fname);
                        this.config.LOCAL_FILE_MODE = true;
                        sr.detect_sample_id();
                        this.config.sams.add(sr);
                        continue;
                    }
                    error_msg = "BAM file " + f + " is not indexed; use \"samtools index file.bam\" to generate.";
                    break;
                }
                error_msg = "file \"" + fname + "\" does not exist.";
                break;
            }
            this.prefs.put(PREF_BAM_FILES, files);
        }
        if (error_msg == null) {
            if (this.config.sams.size() > 0) {
                try {
                    SAMRegion region;
                    this.config.region = region = new SAMRegion();
                    this.config.region_default_setup();
                    Exception ex = SAMUtils.sam_config_setup(this.config, region);
                    if (ex != null) {
                        System.err.println("ERROR: " + e);
                        ex.printStackTrace();
                        if (ex instanceof SQLException || ex.toString().toLowerCase().indexOf("jdbc") > -1) {
                            JOptionPane.showMessageDialog(this, "Problem communicating with database; see Java error log for more details.", "Warning", 2);
                        }
                    }
                    this.config.assembly = new SAMAssembly(this.config, true);
                }
                catch (Throwable t) {
                    new Funk.ErrorReporter(t);
                }
            } else {
                error_msg = "no files specified.";
            }
        }
        if (error_msg != null) {
            JOptionPane.showMessageDialog(this.deep_sigh, "Error: " + error_msg, "Error", 0);
        } else {
            AceViewer av = new AceViewer(this.config);
            this.deep_sigh.setVisible(false);
        }
    }

    private void title_setup() {
        double rand = Math.random();
        String title = rand < 0.65 ? "bambino" : (rand < 0.94 ? "perbambulator" : (rand < 0.97 ? "bamboozle" : "bamnation"));
        this.setTitle(title + ": launcher");
    }

    private void add_paneled_button(JPanel p, JButton jb) {
        JPanel jp = new JPanel();
        jp.setLayout(new BoxLayout(jp, 3));
        jp.add(jb);
        p.add(jp);
    }

    private void configure_reference_sequence(File fn) {
        if (fn == null) {
            this.nib_dir.setText("");
        } else if (fn.isDirectory()) {
            if (this.reference_type == 3 || this.reference_type == 1) {
                this.nib_dir.setText(fn.toString());
            }
        } else {
            String s = fn.toString().toLowerCase();
            if (s.indexOf(".nib") == s.length() - 4) {
                this.nib_dir.setText(fn.getParent());
                this.reference_type = 1;
            } else if (s.indexOf(".2bit") == s.length() - 5) {
                this.reference_type = 2;
                this.nib_dir.setText(fn.toString());
            } else if (s.indexOf(".fasta") == s.length() - 6 || s.indexOf(".fa") == s.length() - 3) {
                File fai = new File(s + ".fai");
                if (fai.exists()) {
                    this.reference_type = 4;
                    this.nib_dir.setText(fn.toString());
                } else {
                    this.nib_dir.setText(fn.getParent());
                    this.reference_type = 3;
                }
            } else {
                System.err.println("ERROR: unknown file type");
                this.nib_dir.setText("error, unknown file");
            }
        }
    }
}

