/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import java.util.Arrays;

public class LongCounter {
    private int MAX_VALUE = 0;
    private long[] tracker;

    public LongCounter(int mv) {
        this.MAX_VALUE = mv;
        this.tracker = new long[this.MAX_VALUE + 1];
        Arrays.fill(this.tracker, 0L);
    }

    public long[] get_array() {
        return this.tracker;
    }

    public void increment(int v) {
        if (v < 0 || v > this.MAX_VALUE) {
            System.err.println("ERROR: can't track out of bounds!!");
        } else {
            int n = v;
            this.tracker[n] = this.tracker[n] + 1L;
        }
    }

    private long get_total_observations() {
        int total = 0;
        for (int i = 0; i < this.tracker.length; ++i) {
            total = (int)((long)total + this.tracker[i]);
        }
        return total;
    }

    private long get_total_values() {
        int total = 0;
        for (int i = 0; i < this.tracker.length; ++i) {
            total = (int)((long)total + this.tracker[i] * (long)i);
        }
        return total;
    }

    public double get_mean() {
        return (double)this.get_total_values() / (double)this.get_total_observations();
    }

    public int get_median() {
        return this.get_fraction(0.5);
    }

    public int get_fraction(double position) {
        double halt_at_count = (double)this.get_total_observations() * position;
        int result = -1;
        double count = 0.0;
        for (int i = 0; i < this.tracker.length; ++i) {
            if (!((count += (double)this.tracker[i]) >= halt_at_count)) continue;
            result = i;
            break;
        }
        return result;
    }

    public static void main(String[] argv) {
        LongCounter lc = new LongCounter(100);
        lc.increment(1);
        lc.increment(2);
        lc.increment(3);
        lc.increment(8);
        lc.increment(12);
        System.err.println("mean=" + lc.get_mean());
        System.err.println("median=" + lc.get_median());
        for (double percentile = 0.0; percentile <= 1.0; percentile += 0.05) {
            System.err.println(percentile + " percentile=" + lc.get_fraction(percentile));
        }
    }
}

