/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.IndelInfo;
import Ace2.SNPConfig;
import Ace2.SNPTrackInfo;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;

public class MapQTracker {
    private SNPConfig config;
    private int average_mapping_quality;
    private static final int MAPQ_NOT_AVAILABLE = 255;

    public MapQTracker(ArrayList list) {
        long total = 0L;
        int count = 0;
        SAMRecord sr = null;
        for (Object o : list) {
            int mapq;
            if (o instanceof SNPTrackInfo) {
                sr = ((SNPTrackInfo)o).sr;
            } else if (o instanceof IndelInfo) {
                sr = ((IndelInfo)o).sr;
            } else {
                System.err.println("ERROR: unhandled object " + o);
                System.exit(1);
            }
            if ((mapq = sr.getMappingQuality()) == 255) continue;
            total += (long)mapq;
            ++count;
        }
        this.average_mapping_quality = count == 0 ? 0 : (int)(total / (long)count);
    }

    public int get_average_mapping_quality() {
        return this.average_mapping_quality;
    }
}

