/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

public class MemoryMonitor {
    private float STRESSED_FREE_MEMORY_FRACTION = 0.005f;
    private int SUSTAINED_STRESS_TIME = 1500;
    private Runtime rt = Runtime.getRuntime();
    private long max_memory = this.rt.maxMemory();
    private long start_stress_time = 0L;

    public boolean is_stressed() {
        long free_memory = this.rt.freeMemory();
        float free_fraction = (float)free_memory / (float)this.max_memory;
        boolean stressed = free_fraction < this.STRESSED_FREE_MEMORY_FRACTION;
        return stressed;
    }

    public boolean is_sustained_stressed() {
        boolean result = false;
        boolean stressed = this.is_stressed();
        long now = System.currentTimeMillis();
        if (stressed) {
            if (this.start_stress_time == 0L) {
                this.start_stress_time = now;
            } else {
                result = now - this.start_stress_time >= (long)this.SUSTAINED_STRESS_TIME;
            }
        } else {
            this.start_stress_time = 0L;
        }
        return result;
    }

    public void set_sustained_stress_time(int ms) {
        this.SUSTAINED_STRESS_TIME = ms;
    }
}

