/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.ExonIntronCoverage;
import Ace2.Range;
import Ace2.Reporter;
import Funk.DelimitedFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class MetaExonIntronCoverage {
    private File bam;
    private File meta_report;
    static boolean VERBOSE = false;

    public void set_meta_report(File f) {
        this.meta_report = f;
    }

    public void set_bam(File f) {
        this.bam = f;
    }

    public void find_coverage() throws Exception {
        if (this.meta_report == null) {
            throw new Exception("specify -meta");
        }
        if (this.bam == null) {
            throw new Exception("specify -bam");
        }
        String outfile = this.bam.getName() + ".meta_exon_intron_coverage.tab";
        System.err.println(outfile);
        Reporter rpt = new Reporter();
        rpt.set_output_filename(outfile);
        ExonIntronCoverage eic = new ExonIntronCoverage();
        eic.set_bam(this.bam);
        DelimitedFile df = new DelimitedFile(this.meta_report);
        ArrayList<String> headers = new ArrayList<String>();
        for (Object o : df.get_labels()) {
            headers.add((String)o);
        }
        for (String h : headers) {
            rpt.add_header(h);
        }
        rpt.add_header("start");
        rpt.add_header("end");
        rpt.add_header("count_exon_bases");
        rpt.add_header("count_intron_bases");
        rpt.add_header("count_reads_exon_exclusive");
        rpt.add_header("count_reads_intron_exclusive");
        rpt.add_header("count_reads_overlap");
        rpt.add_header("fraction_exclusive_reads_intron");
        rpt.add_header("count_reads_fuzzy_exonic");
        rpt.add_header("count_reads_fuzzy_intronic");
        rpt.add_header("count_reads_fuzzy_overlap");
        rpt.add_header("fraction_reads_fuzzy_intronic");
        Vector rows = df.get_rows();
        for (Object o : rows) {
            Hashtable row = (Hashtable)o;
            System.err.println(row.get("chrom"));
            String chrom = (String)row.get("chrom");
            String exon_union = (String)row.get("exon_union");
            ArrayList<Range> exons = new ArrayList<Range>();
            String[] ranges = exon_union.split(",");
            for (int i = 0; i < ranges.length; ++i) {
                String[] start_and_end = ranges[i].split("-");
                Range r = new Range(Integer.parseInt(start_and_end[0]) + 1, Integer.parseInt(start_and_end[1]));
                exons.add(r);
            }
            eic.find_coverage(chrom, exons, rpt);
            for (String h : headers) {
                rpt.set_value(h, (String)row.get(h));
            }
            rpt.end_row();
        }
        rpt.close();
    }

    public static void main(String[] argv) {
        try {
            MetaExonIntronCoverage meic = new MetaExonIntronCoverage();
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].equals("-meta")) {
                    meic.set_meta_report(new File(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-bam")) {
                    meic.set_bam(new File(argv[++i]));
                    continue;
                }
                if (argv[i].equals("-v")) {
                    VERBOSE = true;
                    continue;
                }
                System.err.println("ERROR: unknown parameter " + argv[i]);
                System.exit(1);
            }
            meic.find_coverage();
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }
}

