/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.WorkingFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplexedWriter {
    private String basename;
    private HashMap<String, PrintStream> key2ps;
    private HashMap<String, WorkingFile> key2wf;
    private HashMap<String, File> key2file;
    private HashMap<String, Integer> key2count;
    private boolean compress;
    private int BUCKET_SIZE = 0;
    private int MAX_OPEN_FILEHANDLES = 0;
    private boolean FILEHANDLE_LIMIT = false;
    private static final boolean VERBOSE = false;

    public MultiplexedWriter(String basename, boolean compress) {
        this.basename = basename;
        this.compress = compress;
        this.key2ps = new HashMap();
        this.key2wf = new HashMap();
        this.key2file = new HashMap();
        this.key2count = new HashMap();
    }

    public PrintStream getPrintStream(String key) {
        PrintStream ps = this.key2ps.get(key);
        if (ps == null) {
            if (this.FILEHANDLE_LIMIT) {
                this.filehandle_limit_check();
            }
            boolean append = this.key2file.containsKey(key);
            WorkingFile wf = new WorkingFile(this.get_filename(key), append);
            try {
                this.key2wf.put(key, wf);
                ps = wf.getPrintStream();
                this.key2ps.put(key, ps);
                this.key2file.put(key, wf.get_file());
                if (this.FILEHANDLE_LIMIT) {
                    this.key2count.put(key, 0);
                }
            }
            catch (Exception e) {
                System.err.println("ERROR: can't get PrintStream for key " + key);
                System.err.println("exception=" + e);
                e.printStackTrace();
                System.exit(1);
            }
        }
        return ps;
    }

    public void set_bucket_size(int size) {
        this.BUCKET_SIZE = size;
    }

    public void set_max_open_filehandles(int size) {
        this.MAX_OPEN_FILEHANDLES = size;
        this.FILEHANDLE_LIMIT = true;
        if (this.compress) {
            System.err.println("ERROR: can't use max open filehandle limiter in compressed mode!");
            System.exit(1);
        }
    }

    public String get_filename(String key) {
        return this.basename + key + (this.compress ? ".gz" : "");
    }

    public void write(String key, String value) {
        this.getPrintStream(key).println(value);
        if (this.FILEHANDLE_LIMIT) {
            this.key2count.put(key, this.key2count.get(key) + 1);
        }
    }

    private void filehandle_limit_check() {
        if (this.key2wf.size() > this.MAX_OPEN_FILEHANDLES) {
            int closes_needed = this.key2wf.size() - this.MAX_OPEN_FILEHANDLES;
            ArrayList<String> delete_queue = new ArrayList<String>();
            block0: while (closes_needed > 0) {
                HashSet<Integer> uc = new HashSet<Integer>(this.key2count.values());
                ArrayList<Integer> counts = new ArrayList<Integer>(uc);
                Collections.sort(counts);
                int least = counts.get(0);
                for (String key : this.key2count.keySet()) {
                    int count = this.key2count.get(key);
                    if (count > least) continue;
                    delete_queue.add(key);
                    if (--closes_needed != 0) continue;
                    continue block0;
                }
            }
            for (String key : delete_queue) {
                this.key2wf.get(key).finish();
                this.key2wf.remove(key);
                this.key2ps.remove(key);
                this.key2count.remove(key);
            }
        }
    }

    public int get_bucket_number(int pos) {
        return pos / this.BUCKET_SIZE;
    }

    public String get_bucketed_key(String key_raw, int pos) {
        return key_raw + "." + Integer.toString(this.get_bucket_number(pos));
    }

    public void write_bucketed(String key_raw, int pos, String value) {
        this.write(this.get_bucketed_key(key_raw, pos), value);
    }

    public HashSet<String> getBucketedHashSet(String key, int pos) throws IOException {
        return this.getHashSet(this.get_bucketed_key(key, pos));
    }

    public HashSet<String> getHashSet(String key) throws IOException {
        HashSet<String> hs = new HashSet<String>();
        try {
            String line;
            File f = new File(this.get_filename(key));
            InputStream is = new FileInputStream(f);
            if (this.compress) {
                is = new GZIPInputStream(is);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                hs.add(line);
            }
            is.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return hs;
    }

    public void finish() {
        for (WorkingFile wf : this.key2wf.values()) {
            wf.finish();
        }
    }

    public void delete() {
        for (File f : this.key2file.values()) {
            if (f.delete()) continue;
            System.err.println("ERROR: can't delete " + f);
        }
    }

    public static void main(String[] argv) {
        MultiplexedWriter mw = new MultiplexedWriter("mw_test", false);
        mw.set_max_open_filehandles(2);
        mw.write("1", "1_1");
        mw.write("1", "1.2");
        mw.write("2", "2_1");
        mw.write("2", "2.2");
        mw.write("3", "3_1");
        mw.write("3", "3.2");
        mw.write("3", "3.3");
        mw.write("4", "4_1");
        mw.write("2", "2 re-open");
        mw.finish();
        try {
            HashSet<String> set = mw.getHashSet("2");
            System.err.println("set for 2 = " + set);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
    }
}

