/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Chromosome;
import Ace2.ReferenceSequence;
import Ace2.SAMUtils;
import htsjdk.samtools.cram.ref.ReferenceSource;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NIB
implements ReferenceSequence {
    RandomAccessFile raf;
    private byte[] long_buf = new byte[4];
    File nib_file;
    public static String DEFAULT_NIB_DIR = null;
    private static final byte NT_MASK = 7;
    private static final byte MASK_MASKED = 8;
    private static final int HEADER_BYTES = 8;
    private static final int BUFFER_SIZE = 16384;
    private int BUFFER_INDEX = -1;
    private byte[] BUFFER = null;
    int nib_len;

    public NIB(Chromosome chr) throws FileNotFoundException {
        this.setup(null, chr);
    }

    public NIB() {
    }

    public NIB(String sequence_name) throws FileNotFoundException {
        this.setup(null, sequence_name);
    }

    @Override
    public byte[] get_region(String sequence_name, int start_base, int length) throws IOException {
        byte[] result = null;
        this.setup(null, sequence_name);
        result = this.get_sequence(start_base, length);
        return result;
    }

    @Override
    public byte[] get_all(String sequence_name) throws IOException {
        byte[] result = null;
        this.setup(null, sequence_name);
        result = this.read_all();
        return result;
    }

    @Override
    public int get_length(String sequence_name) throws IOException {
        int length = -1;
        try {
            this.setup(null, sequence_name);
            length = this.nib_len;
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return length;
    }

    private void setup(String directory, Chromosome chr) throws FileNotFoundException {
        this.setup(directory, chr.toString());
    }

    private void setup(String directory, String sequence_name) throws FileNotFoundException {
        this.BUFFER = new byte[16384];
        if (directory == null) {
            directory = this.guess_nib_dir();
        }
        for (String key : SAMUtils.get_refname_alternates(sequence_name)) {
            String fn = directory + File.separator + key + ".nib";
            this.nib_file = new File(fn);
            if (!this.nib_file.exists()) continue;
            break;
        }
        this.raf = new RandomAccessFile(this.nib_file, "r");
        this.nib_len = this.get_sequence_length();
    }

    private String guess_nib_dir() {
        File f;
        int i;
        String[] dirs = new String[]{DEFAULT_NIB_DIR, "/TCGA/nextgensupport/hg18_nib/", "/generatable/hg18/", "/tcga_next_gen/Genome_Analysis/edmonson/support/hg18_nib", "."};
        for (i = 0; !(i >= dirs.length || dirs[i] != null && (f = new File(dirs[i])).exists()); ++i) {
        }
        return dirs[i];
    }

    private int read_vaxian_long() throws IOException {
        int result = 0;
        if (this.raf.read(this.long_buf) != 4) {
            throw new IOException("insufficient bytes to read long");
        }
        result = (this.long_buf[0] & 0xFF) + ((this.long_buf[1] & 0xFF) << 8) + ((this.long_buf[2] & 0xFF) << 16) + ((this.long_buf[3] & 0xFF) << 24);
        return result;
    }

    public int get_sequence_length() {
        int nib_len = -1;
        try {
            this.raf.seek(0L);
            int magic = this.read_vaxian_long();
            nib_len = this.read_vaxian_long();
            int expected_len = (int)(this.nib_file.length() - 8L) * 2;
            if (expected_len != nib_len && expected_len > nib_len) {
                nib_len = expected_len;
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
        return nib_len;
    }

    public byte[] get_sequence(int base_num, int len) throws IOException, EOFException {
        boolean oddity;
        long pos = 8 + (base_num - 1) / 2;
        System.err.println("pos for base " + base_num + " = " + pos);
        this.raf.seek(pos);
        int wanted = len;
        byte[] result = new byte[len];
        int ptr = 0;
        if (base_num + (wanted - 1) > this.nib_len) {
            throw new IOException("attempt to read past end of sequence");
        }
        boolean bl = oddity = (base_num - 1) % 2 > 0;
        while (wanted > 0) {
            int packed_size = wanted / 2 + 2;
            int read_size = packed_size <= this.BUFFER.length ? packed_size : this.BUFFER.length;
            int read = this.raf.read(this.BUFFER, 0, read_size);
            if (read > 0) {
                for (int bi = 0; wanted > 0 && bi < read; ++bi) {
                    if (oddity) {
                        result[ptr++] = this.nibble_to_nt(this.BUFFER[bi]);
                        --wanted;
                        oddity = false;
                        continue;
                    }
                    result[ptr++] = this.nibble_to_nt((byte)(this.BUFFER[bi] >> 4));
                    if (--wanted <= 0) continue;
                    result[ptr++] = this.nibble_to_nt(this.BUFFER[bi]);
                    --wanted;
                }
                continue;
            }
            throw new IOException("read() returned " + read);
        }
        return result;
    }

    public byte[] read_all() throws IOException {
        int read;
        int nib_len = this.get_sequence_length();
        System.err.println("reading full NIB record");
        byte[] result = new byte[nib_len];
        int bi = 0;
        byte[] buffer = new byte[1024];
        block0: while ((read = this.raf.read(buffer)) != -1) {
            for (int i = 0; i < read && bi < nib_len; ++i) {
                result[bi++] = this.nibble_to_nt((byte)(buffer[i] >> 4));
                if (bi >= nib_len) continue block0;
                result[bi++] = this.nibble_to_nt(buffer[i]);
                if (bi >= nib_len) continue block0;
            }
        }
        return result;
    }

    private byte nibble_to_nt(byte nibble) {
        byte result;
        switch (nibble & 7) {
            case 0: {
                result = 84;
                break;
            }
            case 1: {
                result = 67;
                break;
            }
            case 2: {
                result = 65;
                break;
            }
            case 3: {
                result = 71;
                break;
            }
            default: {
                result = 78;
            }
        }
        if ((nibble & 8) > 0) {
            result = (byte)Character.toLowerCase((char)result);
        }
        return result;
    }

    public byte get_nucleotide_at(int base_num) {
        byte result = 32;
        if (base_num < 1 || base_num > this.nib_len) {
            System.err.println("ERROR: base " + base_num + " out of bounds");
        } else {
            int bi = -1;
            try {
                this.get_buffer_for(base_num);
                bi = (base_num - 1 - this.BUFFER_INDEX) / 2;
                result = base_num % 2 > 0 ? this.nibble_to_nt((byte)(this.BUFFER[bi] >> 4)) : this.nibble_to_nt(this.BUFFER[bi]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println("array out of bounds for base num " + base_num + ", bi=" + bi);
            }
        }
        return result;
    }

    private boolean get_buffer_for(int base_num) {
        int bi;
        if (base_num > this.nib_len) {
            base_num = this.nib_len;
        }
        if ((bi = base_num - 1) % 2 == 1) {
            --bi;
        }
        boolean result = true;
        if (this.BUFFER_INDEX == -1 || bi < this.BUFFER_INDEX || bi >= this.BUFFER_INDEX + 16384) {
            long pos = 8 + bi / 2;
            this.BUFFER_INDEX = bi;
            try {
                this.raf.seek(pos);
                this.raf.readFully(this.BUFFER);
            }
            catch (EOFException eOFException) {
            }
            catch (Exception e2) {
                System.err.println("ERROR: " + e2);
                e2.printStackTrace();
                Arrays.fill(this.BUFFER, (byte)0);
                result = false;
            }
        }
        return result;
    }

    public static void main(String[] argv) {
        try {
            NIB nib = new NIB(Chromosome.valueOfString("chr2"));
            System.err.println("nib len=" + nib.get_sequence_length());
            if (argv.length == 2) {
                int start_base = Integer.parseInt(argv[0]);
                int len = Integer.parseInt(argv[1]);
                byte[] chunk = nib.get_sequence(start_base, len);
                String str = new String(chunk);
                System.err.println("chunk=" + str);
                System.err.println("slen=" + str.length());
                System.err.println(new String(chunk));
            } else {
                System.err.println("specify start_base and length");
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    @Override
    public boolean supports_sequence_list() {
        return true;
    }

    @Override
    public ArrayList<String> get_sequence_names() {
        ArrayList<String> results = null;
        System.err.println("FIX ME: NIB.get_sequence_list() not implemented");
        return results;
    }

    @Override
    public ReferenceSource getReferenceSource() {
        System.err.println("ERROR: getReferenceSource() not implemented");
        return null;
    }
}

