/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.IntMap;

public class PagedIntMap
extends IntMap {
    private Object[][] pages;

    public PagedIntMap(int max_value) {
        super(max_value);
        this.setup();
    }

    public PagedIntMap(int max_value, int page_size) {
        super(max_value, page_size);
        this.setup();
    }

    private void setup() {
        int max_page_index = this.MAX_VALUE / this.PAGE_SIZE;
        this.pages = new Object[max_page_index + 1][];
    }

    public void put(int key, Object value) {
        int page_index = key / this.PAGE_SIZE;
        Object[] bucket = this.pages[page_index];
        if (bucket == null) {
            bucket = new Object[this.PAGE_SIZE];
            this.pages[page_index] = bucket;
        }
        bucket[key % this.PAGE_SIZE] = value;
    }

    public Object get(int key) {
        Object[] bucket = this.pages[key / this.PAGE_SIZE];
        return bucket == null ? null : bucket[key % this.PAGE_SIZE];
    }

    public void remove(int key) {
        Object[] bucket = this.pages[key / this.PAGE_SIZE];
        if (bucket != null) {
            bucket[key % this.PAGE_SIZE] = null;
        }
    }

    public void free_through(int key) {
        int first_freeable_page = this.FREED_THROUGH / this.PAGE_SIZE;
        super.free_through(key);
        int last_used_page_index = key / this.PAGE_SIZE;
        for (int pi = first_freeable_page; pi < last_used_page_index; ++pi) {
            this.pages[pi] = null;
        }
    }

    public void bucket_debug() {
        for (int i = 0; i < this.pages.length; ++i) {
            System.err.println("page " + i + ": " + this.pages[i]);
        }
    }

    public static void main(String[] argv) {
        int max_count = 250000000;
        int page_size = 65536;
        PagedIntMap map = new PagedIntMap(max_count, page_size);
        int free_ptr = -10000;
        int i = 0;
        while (i < max_count) {
            if (i % 250000 == 0) {
                System.err.println("at " + i);
            }
            map.put(i, i);
            if (free_ptr >= 0) {
                map.free_through(free_ptr);
            }
            ++i;
            ++free_ptr;
        }
        try {
            System.out.println("killing time...");
            Thread.sleep(50000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }
}

