/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.SAMUtils;
import Ace2.WorkingFile;
import Funk.Str;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairedReadWriter {
    WorkingFile wf_fwd;
    WorkingFile wf_rev;
    PrintStream ps_fwd;
    PrintStream ps_rev;
    private HashMap<String, SAMRecord> pair_first;
    private HashMap<String, SAMRecord> pair_second;
    private int FLUSH_CHECK_INTERVAL = 10000;
    int READ_REPORT_INTERVAL = 1000000;
    int read_count;
    HashSet<String> wanted_ids;

    public PairedReadWriter(String basename, HashSet<String> wanted_ids) throws FileNotFoundException, IOException {
        this.wanted_ids = wanted_ids;
        this.wf_fwd = new WorkingFile(basename + ".fwd.fastq");
        this.wf_rev = new WorkingFile(basename + ".rev.fastq");
        this.ps_fwd = this.wf_fwd.getPrintStream();
        this.ps_rev = this.wf_rev.getPrintStream();
        this.pair_first = new HashMap();
        this.pair_second = new HashMap();
        this.read_count = 0;
    }

    public void scan(SAMRecordIterator query) throws IOException {
        int read = 0;
        while (query.hasNext()) {
            SAMRecord sr;
            if (++read % this.READ_REPORT_INTERVAL == 0) {
                System.err.println("read:" + read + " ids remaining=" + this.wanted_ids.size());
            }
            if (!(sr = (SAMRecord)query.next()).getReadPairedFlag()) {
                throw new IOException("paired reads required");
            }
            if (!this.wanted_ids.contains(sr.getReadName())) continue;
            this.add(sr);
        }
    }

    public boolean close() {
        boolean ok = this.flush_check(true);
        this.wf_fwd.finish();
        this.wf_rev.finish();
        return ok;
    }

    public void add(SAMRecord sr) {
        if (sr.getFirstOfPairFlag()) {
            this.pair_first.put(sr.getReadName(), sr);
        } else if (sr.getSecondOfPairFlag()) {
            this.pair_second.put(sr.getReadName(), sr);
        } else {
            System.err.println("paired read not 1st or 2nd: that's unpossible!!");
        }
        if (++this.read_count % this.FLUSH_CHECK_INTERVAL == 0) {
            this.flush_check(false);
        }
    }

    private boolean flush_check(boolean closing) {
        boolean ok = true;
        HashSet<String> all_ids = new HashSet<String>();
        all_ids.addAll(this.pair_first.keySet());
        all_ids.addAll(this.pair_second.keySet());
        ArrayList<String> prunable = new ArrayList<String>();
        for (String id : all_ids) {
            SAMRecord first = this.pair_first.get(id);
            SAMRecord second = this.pair_second.get(id);
            if (first == null || second == null) continue;
            this.write_pair(first, second);
            prunable.add(id);
        }
        for (String id : prunable) {
            this.pair_first.remove(id);
            this.pair_second.remove(id);
            this.wanted_ids.remove(id);
        }
        if (closing) {
            int leftover = this.wanted_ids.size();
            System.err.print("finishing: ids remaining=" + leftover);
            if (leftover == 0) {
                System.err.print(" all reads found.");
            } else {
                System.err.print(" example:" + new ArrayList<String>(this.wanted_ids).get(0));
                ok = false;
            }
            System.err.println("");
        }
        return ok;
    }

    private void add_basic_tags(SAMRecord sr, ArrayList<String> tags) {
        tags.add(sr.getReadName());
        if (sr.getReadUnmappedFlag()) {
            tags.add("unmapped");
        } else {
            tags.add("mapped");
            tags.add(sr.getReferenceName() + ":" + Integer.toString(sr.getAlignmentStart()) + "-" + Integer.toString(sr.getAlignmentEnd()));
        }
    }

    private void write_pair(SAMRecord sr_f, SAMRecord sr_r) {
        ArrayList<String> tags_f = new ArrayList<String>();
        ArrayList<String> tags_r = new ArrayList<String>();
        this.add_basic_tags(sr_f, tags_f);
        this.add_basic_tags(sr_r, tags_r);
        this.rc_fix(sr_f, tags_f);
        this.rc_fix(sr_r, tags_r);
        SAMUtils.write_fastq(this.ps_fwd, sr_f, Str.join(" ", tags_f));
        SAMUtils.write_fastq(this.ps_rev, sr_r, Str.join(" ", tags_r));
    }

    private void rc_fix(SAMRecord sr, ArrayList<String> tags) {
        if (!sr.getReadUnmappedFlag() && sr.getReadNegativeStrandFlag()) {
            String bases_rc = new String(sr.getReadBases());
            String fixed = Str.reverse_complement(bases_rc);
            char[] fixed_c = fixed.toCharArray();
            byte[] fixed_b = new byte[fixed_c.length];
            for (int i = 0; i < fixed_c.length; ++i) {
                fixed_b[i] = (byte)fixed_c[i];
            }
            sr.setReadBases(fixed_b);
            StringBuilder sb = new StringBuilder(sr.getBaseQualityString());
            sr.setBaseQualityString(sb.reverse().toString());
            tags.add("rc_fixed");
        }
    }
}

